/*------------------------------------------------------------------------------*
 * File Name: DataIDs.h															*
 * Creation: CPY Feb 23, 2004												    *
 * Purpose: IDs for all basic data elements and data objects					*
 * Copyright (c) OriginLab Corp.2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice QA70-6232 PRO_ONLY_MASK_FOR_SOME_FEATURE								*
 * CPY 10/14/04 QA70-7029 COR_CORR_USE_MATRIX									*
 * EJP 12-15-2004 v8.0174 QA70-7252 ADD_ID_TO_ASCIMP							*
 *	ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS						*
 *	Echo 3/22/05 v8.0207 QA70-6204 ADD_GSD										*
 *	RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS							*
 *	ML 4/12/2005 QA70-7316 FULL_TABLE_AND_ROW_OR_COL_LABELS_PLUS_DATA_LINKS		*
 *	YuI 04/14/05 MULTIPLE_CURVE_ANALYSIS_BUG									*
 *	ML 4/29/2005 RETURNING_VALUE_FROM_XFUNCTION									*
 *	ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION					*
 *	ML 5/17/2005 SELECTION_SENSITIVE_XF_CTXT_MENUS								*
 *	ML 5/17/2005 QA70-7686 X_FUNCTION_DRIVEN_MENUS_WITH_TREE					*
 *	TD 6-14-05 QA70-7803 XF_NO_LIMIT_EDITABLE_BLOCKS_SUPPORT					*
 *  Liko 6/14/2005	CONSTRUCT_GUI_TREE											*
 * EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS			*
 *	ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS										*
 *	ML 6/28/2005 ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS							*
 *  DG 6/30/05 v8.0260 SMOOTHING_VAL_FOR_DIFF_METHOLD							*
 *	ML 7/20/2005 FITTING_FUNCTION_FORMULA_IN_REPORT								*
 *	ML 7/21/2005 OPTIONAL_MANDATORY_AND_PROHIBITED_ID_CONTEXTS					*
 *	YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT										*
 *	ML 8/12/2005 ACCELERATORS_FROM_MENU_TREE									*
 *	ML 8/18/2005 PROHIBITED_CATEGORIES											*
 *	Kevin 09/01/05 CHANGE_STATISTICS_NAME										*
 *  SY 09/20/2005 ASCII_IMPORT_OPTION_ID_REASSIGN								*
 *	EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM							*
 *	DSC 9/21/05 QA70-8113 KEEP_REPEAT_BRANCH_ID_FROM_BRANCH_MASK				*
 *	CPY 9/30/06  ADD_DOC_REVISION_LOG											*
 *	Kevin 10/13/05 UPDATE_FOR_FIT_LR_OPTION										*
 *	ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS									*
 *	ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS									*
 *	Max 11/11/05 ADD_DOF_STATISTIC_FOR_MEANCOMPSTATS							*
 *	Max 11/12/05 STRUCTURE_FOR_RM_ANOVA											*
 *	TD 12-29-05 Qa70-8431 CHECK_BOX_TO_INDICATE_INCLUDE_FILES_FROM_XF_PATH		*
 * 	EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX						*
 *	CPY 2/21/06 ADD_FOOT_NOTE_TO_TABLE											*
 * 	Jim 2/24/06 ADD_RESIDUAL_LAG_PLOT_TO_RESIDUALS_PLOTS_BRANCH					*
 * EJP 2006-03-01 v8.0371 MOVE_OC_FILTER_UTILS_TO_VC							*
 *	DSC 3/15/06 ADD_MODULE_NODE_TO_XF_TREE										*
 *	TD 5-19-06 QA70-8579 OC_GENERAL_MECHANISM_TO_SAVE_XFNCTIONS_IN_ORIGIN_FILES	*
 *	ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY								*
 *	ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
 *	ML 8/10/2006 REMOVING_CUSTOM_TABLE_FROM_GUI									*
 *	CPY 8/27/06 QA70-8640 FILE_IMPORT_USING_XF_BUT_NO_NEED_FOR_THEME_IN_MENU	*
 *	Cheney 2006-8-31 FOR_ADDING_PLOT_TYPE_NODE_IN_FIT_LINEAR					*
 *	ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL							*
 *	Echo 9/4/06 XF_REPORT_TREE													*
 *	ML 9/5/2006 MASKED_MISSING_NLFIT_TABLES										*
 *	Echo 9/8/06 ATTN_NOTE_IN_REPORT												*
 *	Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH						*
 *	Jospeh  11/16/06 ADD_PARAMETER_SETTING_TO_THEME								*
 *	Cheney 2006-1-1 ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL					*
 *	ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS									*
 *	Cheney 2007-2-6 ADD_OPTION_TO_SUPPORT_SPECIAL_NUM_FORMAT_FOR_ASCIMP			*
 *	TD 2-13-07 QA70-9340 SAVE_ONLY_USER_FUNCTIONS								*
 *	Sim 2-25-07 ADD_FILE_PATH_OPTION_FOR_RENAME_WORKBOOK						*
 *  SY 2007-03-19 QA70-9471 v8.0585 LOCALIZE_XF_DESCRIPTION						*
 *	AW 04/03/07 QA80-9548 v8.0597 XF_LOCALIZATION								*
 *	Cheney 2007-4-4 SHOW_LB_UB_IN_REPORT_SHEET									*
 *	Sim 04-13-2007 MAKE_MECHANISM_FOR_USER_DATA_ID_IN_XF						*
 * CPY 4/19/07 QA70-9659 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT						*
 *	Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS				*
 *	Cheney 2007-6-13 SHOULD_ADD_SIGNIFICANT_DIGIT_IN_PARAMETER_SETTING_NODE		*
 *	Sim 06-22-2007 OPTION_TO_KEEP_BUTTON_STATUS_ON_EVENT						*
 *	Sim 07-09-2007 AUTO_PREVIEW_MECHANISM										*
 *	Sim 07-30-2007 SUPPORT_APPLY_AND_UNDO_FOR_DYNA_BOX							*
 *	Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT*
 *	RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS				*
 *	Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE										*
 *	Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR	*
 *	Folger 11/08/07 IDV_GETN_CUSTOM_BUTTONS										*
 *	Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME	*
 *	Folger 11/27/07 ADD_PFW_MORE_INFORMATION_TABLE								*
 *	Folger 12/03/07 ADD_AUTO_APPLY_CHECKBOX_TO_ENABLE_AUTO_ALLPY_IN_XF_DYNA_DIALOG
 *	Hong 12/05/07 v8.0761 IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA						*
 *	Folger 12/07/07 ADD_BASELINE_INFO_AND_FIT_INFO_TABLE						*
 *	Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE		*
 *	Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME		*
 *	Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said			*
 *	Jasmine 03/26/08 RESERVE_ID_RANGE_FOR_REPORT_FIELD							*
 *	RVD 4/1/2008 QA70-11338 v8.0836 DELETE_POLYLINE_SELECTED_POINT				*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Folger 04/21/08 ADD_BASELINE_MODE_TABLE_IDS									*
 *	Folger 05/04/08 FIX_ANCHOR_POINTS_TABLE_USE_NORMAL_CELL_VALUE_INSTEAD_OF_VECTOR
 *	Folger 05/16/08 IMPROVE_BASELINE_MODE_TABLE									*
 *  Jack 9-19-2008 QA80-12191  SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS	*
 *	CPY 11/02/08 QA70-12512 XF_MANAGEMENT_DURING_ORIGIN_UPDATE					*
 *	Folger 12/03/08 QA80-12701 v8.0982 THEME_SETTING_CONTROL_FOR_BASELINE_FUNCTION_APPLIED_IN_PA_FIT
 *	Sophy 12/17/2008 v8.0987d  QA80-12784 ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS
 *	Folger 01/04/09 QA80-12962 MORE_WORK_ON_GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA
 *	YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS									*
 *	RVD 2/17/2009 QA70-13131 ANCHOR_KEY_EVENTS									*
 *	YuI 03/23/09 QA70-12160 XYRANGE_XERROR_SUPPORT								*
 *	Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR	*
 *	Kyle 04/09/2009 QA80-3224-P2 SHOW_SELECTED_METHOD_IN_REPORT_NOTES			*
 *	Sim 09-25-2009 QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION	*
 *	CPY 7/16/09 QA80-13947-P6 SLIDESHOW_NEED_LAYOUT_TO_ALSO_ENABLE_MENU			*
 *	Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS					*
 *	Folger 02/12/09 QA80-12962 PROPER_ASSIGN_ID_FOR_NEW_ADDED_NODES				*
 *	Folger 07/01/09 THEME_SAVED_IN_SR5_FAILS_TO_BE_APPLIED_AFTER_NEW_RESULTS_NODE_ADDED_IN_PA
 *	Folger 08/07/09 UNIT_IN_PA_FITTING_PARAMETER_MAKE_OLD_THEME_FAIL_TO_APPLY_IN_81
 *	Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS			*
 *	Hong 08/31/09 QA80-12899 IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE			*
 *	Hong 09/09/09 QA80-14287 FREQUENCY_COUNT_ADD_MIN_MAX_COUNT					*
 *	Sim 09-16-2009 QA81-11497-P7 ADD_MAXIMUM_FOR_RANDOM_KRIGING_METHOD			*
 *	YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION						*
 *  Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE								* 
 *	Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED					*
 *	Folger 12/18/09 QA81-14859 THEME_SETTINGS_SUPPORT_APPLY_FIXED_STATUS_ONLY	*
 *	Folger 05/19/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO				*
 *	Folger 07/07/10 ORG-502-S3 SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR	*
 *	Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL						*
 *------------------------------------------------------------------------------*/

#ifndef _DATA_IDS_H
#define _DATA_IDS_H

//#define NLSF_PARAM_TREE_CONSRUCTION_MOVE_VC

/// RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
#define	NLSF_PARAM_TREE_CONSRUCTION_MOVE_VC
#define NLSF_PARAM_BIGGER_RANGE
// do not change this number without changing IDE_NL_PARAMS_* below
#ifdef	NLSF_PARAM_BIGGER_RANGE
#define	  MAX_NLSF_PARAM_COUNT		999
#else
#define	  MAX_NLSF_PARAM_COUNT		99
#endif	//NLSF_PARAM_BIGGER_RANGE
/// end FIX_NLFIT_LIMIT_20_PARAMETERS

 
/**
Rule of using DataID in GUI tree with Theme feature

1: Can not use duplicate DataID in same level of same node: 
For example:						Right Case				Wrong Case
				|--node1			(DataID = 1) 		 	(DataID = 1)
				|----First = dd		(DataID = 11) 			(DataID = 11)
				|--node2   			(DataID = 2) 		 	(DataID = 1) (Wrong)
				|----Third = b  	(DataID = 12) 			(DataID = 12)
				|--node3		    (DataID = 3) 		 	(DataID = 3)
				|----Second = a     (DataID = 13) 			(DataID = 13)
				|--node4   			(DataID = 4) 		 	(DataID = 4)
				|----Fourth = c   	(DataID = 14) 			(DataID = 14)
2: Using same DataID in same level but not same parent node.
Using same DataID in same level but not parent node, user can special RepeatID in parent node,
then he can use same DataID in different node of same level.
3: The range of DataID:
If the GUI tree without RepeatID, the dataid's range: 1 ~~oxffffffff.
RepeatID is using to support same dataid in sub node, it can special same DataId in treenode that
 not in same level.
RepeatID's range:
		1 < RepeatID's < MAX_REPEAT_ID_VALUE 
RepeatID use in the branch node, the leaf node under this node's range: 
		0x00010000 > DataID(sub node under repeated node) > INVALID_TREENODE_DATAID.
4: Best every node of GUI tree exist DataID.
*/
//This enum list contains all the quantities and groups (struct, tree branches) that
//will appear in any GUI for analysis and in any report that are generated from analysis
//Each entry in this enum must have a hardcoded value as once the entry is added, its
//value must not be changed.

typedef enum tagIDE_ID    /// AW 04/30/04 need use typedef so it can be added in precompiling time
{
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///////////////  Section 1, struct elements, options and results  ////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
	IDE_DS_THEME_FILTER			=  13, ///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	IDE_XF_DS_PARAM1				=  14, ///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	IDE_AUTO_UPDATE				=  15, //Forest 09/11/04
	IDE_OUTPUT_RESULTS_LOG		=  16, //----- CPY 4/3/2007 QA70-9566 OUTPUT_TO_RESULTS_LOG_CHECKBOX_IN_GETN
	
	IDE_END_XF_SYS_ADDED_NODES	=  17, //---- CPY 4/21/07 XF_DLG_HAS_SYS_ADDED_NODES
	// DescStatResults
    IDE_STATS_ON_ROWS		    =  18, /// Iris 10/24/05 make sure all node have ID, otherwise theme will not work
	IDE_SAMPLE_SIZE				=  20,
	IDE_NUM_MISSING				=  25,
	IDE_SUM						=  30,
	IDE_MEAN					=  35,
	IDE_MODE					=  38,///Echo 11/22/05 v8.0339 ADD_MODE
	IDE_GEO_MEAN				=  40,
	IDE_GEO_SD					=  42,///Echo 3/22/05 v8.0207 QA70-6204 ADD_GSD
///Kevin 09/01/05 CHANGE_STATISTICS_NAME
	//IDE_LCI						=  45,
	//IDE_UCI						=  50,
	IDE_LCL						=  45,
	IDE_UCL						=  50,
///End CHANGE_STATISTICS_NAME
	IDE_SD						=  55,
	IDE_SD_X_2					=  60,
	IDE_SD_X_3					=  65,
	IDE_SEM						=  70,
	IDE_VARIANCE				=  75,
	IDE_COV						=  80,
	IDE_SKEWNESS				=  85,
	IDE_KURTOSIS				=  90,
	IDE_MAD						=  95,
	IDE_UNCORSUMSQ				= 100,
	IDE_CORSUMSQ				= 105,
	IDE_WEIGHTSUM				= 110,

	// RangeResults, QuantileOptions, and QuantileResults
	IDE_WEIGHT_METHOD			= 114, /// Iris 5/04/2009 QA80-11982 STATS_ON_COL_ADD_WEIGHT_METHOD
	IDE_INTERPOLATE				= 115,
	IDE_VAR_DIVISOR				= 116, ///DSC 9/20/05 QA70-8113 ADD_IDE_VAR_DIVISOR
	IDE_MIN						= 120,
	IDE_IMIN					= 125,
	IDE_P25						= 130,
	IDE_MEDIAN					= 135,
	IDE_P75						= 140,
	IDE_MAX						= 145,
	IDE_IMAX					= 150,
	IDE_IQR						= 153,
	IDE_RANGE					= 155,
	IDE_USE_CUSTOM_PERCENTILES	= 157,
	IDE_CUSTOM_PERCENTILES		= 158, // offset from this index
	IDE_COMPUTER_CONTROL		= 159,
	IDE_EXTREME_VALUES 			= 160, /// Iris 01/09/05 QA70-6367 ADD_EXTREME_VALUES
	
	//---- CPY 10/14/04 QA70-7029 COR_CORR_USE_MATRIX
	IDE_COR_MATIRX				= 170,
	IDE_CORR_MATRIX				= 171,
	//----
	// FreqCountOptions
	/// Hong 09/09/09 QA80-14287 FREQUENCY_COUNT_ADD_MIN_MAX_COUNT
	IDE_FC_MIN					= 153,
	IDE_FC_MAX					= 154,
	/// end FREQUENCY_COUNT_ADD_MIN_MAX_COUNT
	IDE_FC_BIN_START			= 175,
	IDE_FC_BIN_END				= 176,
	IDE_FC_BIN_INC				= 177,
	IDE_FC_STEP_BY				= 178,
	IDE_FC_NUM_INTERVAL			= 179,
	IDE_FC_OUTLIER_LT			= 180,
	IDE_FC_OUTLIER_GT			= 185,
	
	//FreqCountQuantities 
	IDE_FC_BIN_CENTER			= 186,
	IDE_FC_BIN_BOUND			= 187,
	IDE_FC_COUNT				= 188,
	IDE_FC_CUMUL_COUNT			= 189,
	IDE_FC_REL_FREQ				= 191,
	IDE_FC_CUMUL_FREQ			= 193,

	//PR 
	IDE_POLY_ORDER				= 194,  ///Iris 4/19/05
	
	// LROptions
	//IDE_LR_THROUGH_ZERO		= 190,
	IDE_LR_FIX_SLOPE			= 195,
	IDE_LR_FIX_SLOPE_AT			= 200,
	IDE_FIT_ERROR_BARS			= 205,
	IDE_FIT_REDUCED_CHISQR		= 210,
	IDE_FIT_CONF_PERCENT		= 215,
	IDE_FIT_APPARENT_SCALE		= 220,
	IDE_LR_FIX_INTCPT			= 225,
	IDE_LR_FIX_INTCPT_AT		= 230,
	//IDE_LR_USE_RANGE			= 235,
	//IDE_LR_X1					= 240,
	//IDE_LR_X2					= 245,

	// NLSFOptions
	IDE_NLSF_TOLERANCE			= 235,
	IDE_NLSF_MAX_ITERATIONS		= 237,
	IDE_NLSF_DERIV_DELTA		= 240,
	IDE_NLSF_DERIV_DELTA_MIN	= 241,
	IDE_NLSF_DERIV_DELTA_MAX	= 242,
	IDE_NLSF_DERIV_DELTA_FIXED	= 244,
	IDE_NLSF_CATEGORY			= 246,
	IDE_NLSF_FUNCTION			= 248,
	IDE_NLSF_COMP_METHOD		= 250,	///Kevin 09/02/05
	IDE_NLSF_REPLICA_NUM		= 252,	/// Iris 10/13/05 ADD_REPLICA_NUM_OPTION_FOR_PEAK_FUNC


	// FitResultCurveOptions
	IDE_FIT_DO_PLOT				= 256, /// Iris 2/25/2008 v8.0811 MAKE_FIT_CURVE_PLOT_AND_DATA_HAVE_SEPARATE_CONTROL
	IDE_FIT_USE_DATA_X			= 257,
	IDE_FIT_X_POINTS		    = 258,
	IDE_FIT_RESIDUALS			= 260,
	IDE_FIT_RANGE_FULL_X		= 262,
	IDE_FIT_RANGE_MARGIN		= 265,
	IDE_FIT_Y_RANGE_MARGIN		= 266,  ///Iris 8/18/05 ENABLE_DISABLE_SAME_AS_INPUT_DATA
	IDE_FIT_PLOT_TYPE			= 267,  ///Cheney 2006-8-31 FOR_ADDING_PLOT_TYPE_NODE_IN_FIT_LINEAR
	/// Iris 01/23/2007 v8.0546 TO_CONTRL_NOT_OR_HOW_PLOT_FIT_CURVE
	IDE_FIT_PLOT_FIT_CURVE		= 268,	
	IDE_FIT_UPDATE_LEGEND		= 269,
	///end TO_CONTRL_NOT_OR_HOW_PLOT_FIT_CURVE
	IDE_FIT_CURVE_COLOR			= 270,
	IDE_FIT_CONF_BANDS			= 271,
	IDE_FIT_PRED_BANDS			= 272,
	///Arvin 03/11/08  QA70-11234 REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
	IDE_FIT_INNER_RESIDUAL_LIMIT= 273,
	IDE_FIT_OUTER_RESIDUAL_LIMIT= 274,
	///END REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
	IDE_FIT_CONF				= 275,
	IDE_FIT_SET_COLOR			= 276,	///Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	IDE_FIT_PREV				= 277,	/// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE	
	#ifdef	MARKER_VISIBILITY_OPTIONS
	IDE_FIT_SHOW_MARKER			= 278,	///Jasmine 05/30/08 QA80-11630 ADD_OPTION_FOR_SHOW_MARKER_IN_SRC_PLOT_AFTER_FIT
	#endif //	MARKER_VISIBILITY_OPTIONS
	IDE_FIT_X_MIN				= 280,  /// Iris 6/07/05 NLSF_SUPPORT_XYZ_DATA
	IDE_FIT_X_MAX				= 282,
	IDE_FIT_Y_MIN				= 284,
	IDE_FIT_Y_MAX				= 286,
	IDE_FIT_Y_POINTS			= 290,
	IDE_FIT_USE_DATA_XY			= 295,   	
	IDE_FIT_RANGE_FULL_XY		= 298,
	IDE_FIT_DATA_TYPE_BRANCH    = 300,  ///Iris 7/29/05 UPDATE_FITTED_CURVE_OPTIONS
	IDE_FIT_Y_DATA_TYPE_BRANCH  = 301,  ///Iris 8/18/05 ENABLE_DISABLE_SAME_AS_INPUT_DATA
	IDE_FIT_Y_RANGE_BRANCH      = 304, 
	IDE_FIT_RANGE_BRANCH        = 305,
/// Kevin 10/13/05 UPDATE_FOR_FIT_LR_OPTION
	IDE_FIT_ELLIPSE				= 306,
	IDE_FIT_MEAN				= 307,
	//IDE_FIT_ELLIPSE_CONFIDENCE	= 308,
	IDE_FIT_PREDICTION			= 309,
	IDE_FIT_DATAPOINT			= 310,
///End UPDATE_FOR_FIT_LR_OPTION
	IDE_FIT_ELLIPSE_CONFIDENCE_MEAN	= 311,
	IDE_FIT_ELLIPSE_CONFIDENCE_PREDI = 312,

	// FitParameter
	IDE_PARAM_VALUE				= 320,
	IDE_PARAM_ERROR				= 321,
	IDE_PARAM_FIX				= 322,
	IDE_PARAM_SHARED			= 323,	///Jasmine 11/08/07 ADD_SHARED_TO_PARAMETER_REPORT_TABLE
	IDE_PARAM_TVALUE			= 325,
///Kevin 09/01/05 CHANGE_STATISTICS_NAME
	//IDE_PARAM_LCI				= 330,
	//IDE_PARAM_UCI				= 331,
	IDE_PARAM_LCL				= 330,
	IDE_PARAM_UCL				= 331,
///End CHANGE_STATISTICS_NAME
	IDE_PARAM_UNIT				= 332,		///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
	IDE_PARAM_PROB				= 334,
	IDE_PARAM_DEPENDENCY		= 337,
	///Cheney 2007-4-4 SHOW_LB_UB_IN_REPORT_SHEET
	//IDE_PARAM_CONF_INT			= 340,
	IDE_PARAM_CONF_INT			= 338,
	IDE_PARAM_LOWER_BOUND		= 339,
	IDE_PARAM_UPPER_BOUND		= 340,
	///end SHOW_LB_UB_IN_REPORT_SHEET
	IDE_PARAMS_SUMMARY			= 342, /// Iris 01/09/2007 v8.0539 ADD_PARAMTERS_SUMMARY_TABLE
	
	/// Iris 02/28/2007 v8.0572 ADD_OPTIONS_TO_CONTRL_CONTENTS_IN_SUMMARY_TABLE
	IDE_SUMMARY_PARAM_VALUE		= 343,
	IDE_SUMMARY_PARAM_ERROR		= 344,
	IDE_SUMMARY_PARAM_LCL 		= 345,
	IDE_SUMMARY_PARAM_UCL		= 346,
	IDE_SUMMARY_STATS_ADJ_RS	= 347,
	IDE_SUMMARY_STATS_RS		= 348,
	IDE_SUMMARY_STATS_CHISQ		= 349,
	///end ADD_OPTIONS_TO_CONTRL_CONTENTS_IN_SUMMARY_TABLE
	
	// RegStats
	IDE_FIT_NUM_POINTS			= 350,
	IDE_FIT_DOF					= 351,
	IDE_FIT_RVALUE				= 352,
	IDE_FIT_RSQUARE_COD			= 355,
	IDE_FIT_ADJ_RSQUARE			= 356,
	IDE_FIT_ROOT_MSE			= 360,
	IDE_FIT_CHI_SQUARE			= 365,
	IDE_FIT_REDUCED_CHI_SQUARE	= 366,
	IDE_FIT_SSR					= 367,
	IDE_FIT_CORRELATION			= 370,
	//IDE_FIT_COD					= 372,
	IDE_FIT_CONFIDENCE			= 372,
	IDE_FIT_NORM_REDIDUALS		= 380,
	IDE_FIT_NUMBER_ITER			= 382,
	IDE_FIT_STATUS				= 384,
	///Cheney 2007-11-2 QA70-10626 ADD_REPLICA_INFO_IN_REPORT_TABLE
	IDE_REPLICA_NUM				= 385,
	IDE_REPLICA_FROM_NTH_PARAM	= 386,
	IDE_NUM_OF_PARAMS_IN_REPLICA= 387,
	///end ADD_REPLICA_INFO_IN_REPORT_TABLE
	IDE_FIT_POLYNOMIAL_ORDER	= 388,///Cheney 2007-11-16 OUTPUT_POLYNOMIAL_ORDER_FOR_FIT_PLOYNOMIAL
	
	// NLSFStats
	IDE_NLSF_MU_FINAL			= 390,
	IDE_NLSF_MU_MIN				= 395,
	IDE_NLSF_DERIV_STEP			= 400,
	IDE_NLSF_PARAM_CHANGE		= 405,
//	IDE_NLSF_TOLERANCE			= 410, // Enumerated in NLSFOptions
	IDE_NLSF_ITERATIONS			= 407,
	IDE_NLSF_RANGE1				= 409,
	IDE_NLSF_RANGE2				= 412,
	IDE_NLSF_STEP				= 417,
	IDE_NLSF_CONFIDENCE			= 420,
//	IDE_NLSF_NUM_POINTS			= 445,
	IDE_NLSF_CONSTRAINTS		= 423,
	IDE_NLSF_EFF_CONSTRAINTS	= 425,

	//CPY 11/10/04
	IDE_NLSF_CODES_FUNC			= 430,
	IDE_NLSF_CODES_PARAINIT		= 432,
	IDE_NLSF_CODES_BEFOREFIT	= 435,
	IDE_NLSF_CODES_AFTERFIT		= 437,
	IDE_NLSF_CODES_CONSTRAINTS	= 438,
	IDE_NLSF_CODES_DERIVATIVE	= 439,
	
	// RegANOVARow
	IDE_FIT_ANOVA_DOF			= 460,
	IDE_FIT_ANOVA_SUM_SQUARES	= 465,
	IDE_FIT_ANOVA_MEAN_SQUARE	= 470,

	// RegANOVA
	IDE_ANOVA_TABLE				= 475,
	IDE_ANOVA_FVALUE			= 480,
	IDE_ANOVA_PVALUE			= 485,

	// HypotTestOptions
	IDE_TEST_TYPE				= 490,
	IDE_TEST_VALUE				= 495,
	IDE_TAIL_TYPE				= 500,
	IDE_ALTHYPOT				= 502,

	// tTestMean1SampleResults
	IDE_TTEST1_SAMPLE_SIZE		= 505, 
	IDE_TTEST1_MEAN				= 510, 
	IDE_TTEST1_SD				= 515, 
	IDE_TTEST1_SEM				= 520, 
	IDE_TTEST1_DOF				= 525,
	IDE_TTEST1_T_VALUE			= 530,
	IDE_TTEST1_PROB				= 535,

	//Desctive results for tTest
	IDE_TTEST_DESC_N			= 536,
	IDE_TTEST_DESC_MEAN			= 537,
	IDE_TTEST_DESC_SD			= 539, 
	IDE_TTEST_DESC_SEM			= 540,
	
	//test results for tTest
	IDE_TTEST_RES_DOF			= 542,
	IDE_TTEST_RES_T_VALUE		= 543,
	IDE_TTEST_RES_PROB			= 545,
	
	//Confidence interval
	IDE_CONF_INTER_MEAN			=546,
	IDE_CONF_LEVEL_MEAN			=548,
	IDE_CONF_INTER_VAR			=549,
	IDE_CONF_LEVEL_VAR			=550,
	
	// ChiSqVar1SampleResults and ChiSqVar2SampleResults
	IDE_CHISQ_DOF				= 538,
	IDE_CHI_SQ_VALUE			= 541,
	IDE_CHISQ_PROB				= 544,
	IDE_CHISQ2_DOF				= 547,
	IDE_CHI_SQ2_VALUE			= 551,
	IDE_CHISQ2_PROB				= 553,
	
	//tTestMean2SampleResults
	IDE_TTEST2_SAMPLE_SIZE1		= 555, 
	IDE_TTEST2_MEAN1			= 560, 
	IDE_TTEST2_SD1				= 565, 
	IDE_TTEST2_SEM1				= 570, 
	IDE_TTEST2_SAMPLE_SIZE2		= 575, 
	IDE_TTEST2_MEAN2			= 580, 
	IDE_TTEST2_SD2				= 585, 
	IDE_TTEST2_SEM2				= 590, 
	IDE_TTEST2_DIF_MEAN			= 595,
	IDE_TTEST2_DIF_SEM			= 600,
	IDE_TTEST2_DOF				= 605, 
	IDE_TTEST2_T_VALUE			= 610, 
	IDE_TTEST2_PROB				= 615, 

	// FVarResults
	IDE_F_DOF_NUM				= 620,
	IDE_F_DOF_DEN				= 625,
	IDE_F_VALUE					= 630,
	IDE_F_PROB					= 635, 

	//Power analysis
	IDE_POWERS_ACTUAL   		= 621,
	IDE_POWERS_ALPHA			= 622,
	IDE_POWERS_HYPOT			= 623,
	IDE_POWERS_SAMPSIZE			= 624,
	IDE_POWERS_POWER			= 626,

	//Sample size output
	IDE_SAMPLESIZE_ALPHA		= 627,
	IDE_SAMPLESIZE_POWER		= 628,
	IDE_SAMPLESIZE_SAMPSIZE		= 629,
	
	// NormTestResults
	IDE_NORM_DOF				= 640, 
	IDE_NORM_TEST_STAT			= 645,
	IDE_NORM_PROB				= 650, 

	// ANOVADescStats
	IDE_ANOVA_GROUP_SIZE		= 655,
	IDE_ANOVA_GROUP_MEAN		= 660,
	IDE_ANOVA_GROUP_SD			= 665,
	IDE_ANOVA_GROUP_SEM			= 670,

// Echo 5/7/04 Add for ANOVA functions
	//MeanCompStats
	IDE_ANOVA_INDEXCOMP			= 678,		/// Max 03/16/05 ADD_MORE_STATISTIC_FOR_MEAN_COMPARISON
	IDE_ANOVA_MEANDIFF			= 671,
	/// Max 11/11/05 ADD_DOF_STATISTIC_FOR_MEANCOMPSTATS
	IDE_ANOVA_DOF				= 712,
	// End ADD_DOF_STATISTIC_FOR_MEANCOMPSTATS
	IDE_ANOVA_SEM				= 672,
	IDE_ANOVA_STAT				= 679,
	IDE_ANOVA_PROB				= 673,
	IDE_ANOVA_SIG				= 681,
	IDE_ANOVA_ALPHA				= 682,
///Kevin 09/01/05 CHANGE_STATISTICS_NAME
	//IDE_ANOVA_LCI				= 674,
	//IDE_ANOVA_UCI				= 676,
	IDE_ANOVA_LCL				= 674,
	IDE_ANOVA_UCL				= 676,
///End CHANGE_STATISTICS_NAME
	//ANOVAStats
	IDE_ANOVA_RSQ				= 675,
	IDE_ANOVA_COV				= 680,	
	IDE_ANOVA_MSESQ				= 685,
	IDE_ANOVA_MEAN				= 690,

// Echo 5/10/04	
	IDE_ANOVA2_SIZE				= 691,
	IDE_ANOVA2_MEAN				= 692,
	IDE_ANOVA2_SD				= 693,
	IDE_ANOVA2_SEM				= 694,
	IDE_ANOVA2_VAR				= 696,
	IDE_ANOVA2_MISS				= 697,
	IDE_ANOVA2_NONMISS			= 698,

// Echo 5/10/04 Add for Survival Analysis
	IDE_SURVANAL_TIME			= 699,
	IDE_SURVANAL_STATUS			= 702,
	IDE_SURVANAL_SURV			= 695,
	IDE_SURVANAL_SD				= 700,
	IDE_SURVANAL_EVENTS			= 705,
	IDE_SURVANAL_REMAIN			= 710,	

	IDE_SAQUANTEST_PERC			= 715,
	IDE_SAQUANTEST_LCL			= 720,
	IDE_SAQUANTEST_UCL			= 725,

	IDE_SAMEANEST_EST			= 704,
	IDE_SAMEANEST_SE			= 707,
	IDE_SAMEANEST_LCL			= 714,
	IDE_SAMEANEST_UCL			= 717,
	IDE_SAMEANEST_LIMITED		= 722,

	IDE_SURVSUMM_TOTAL			= 730,
	IDE_SURVSUMM_EVENTS			= 735,
	IDE_SURVSUMM_NUMCEN			= 740,
	IDE_SURVSUMM_PERCEN			= 745,

	IDE_SAFITSTATS_CRITER		= 750,
	IDE_SAFITSTATS_CHISQ		= 755,
	IDE_SAFITSTATS_DF			= 756,
	IDE_SAFITSTATS_PROB			= 757,

	IDE_SAPARAESTIM_DF			= 760,
	IDE_SAPARAESTIM_PARAES		= 765,
	IDE_SAPARAESTIM_SE			= 770,
	IDE_SAPARAESTIM_LCL			= 772,
	IDE_SAPARAESTIM_UCL			= 774,
	IDE_SAPARAESTIM_CHISQ		= 775,
	IDE_SAPARAESTIM_PROB		= 780,
	IDE_SAPARAESTIM_HAZARD		= 785,	
	
	///Echo 1/19/05 Add for life table
	IDE_LIFETBL_TMLCL			= 751,
	IDE_LIFETBL_TMUCL			= 752,
	IDE_LIFETBL_TOTAL			= 753,
	IDE_LIFETBL_NCENSORED		= 754,
	IDE_LIFETBL_NFAILED			= 758,
	IDE_LIFETBL_NRISK			= 759,
	IDE_LIFETBL_PROPSURV		= 761,
	IDE_LIFETBL_PROPFAIL		= 762,
	IDE_LIFETBL_SURV			= 763,
	IDE_LIFETBL_FAIL			= 764,
	IDE_LIFETBL_SESURV			= 766,
	IDE_LIFETBL_PDF				= 767,
	IDE_LIFETBL_SEPDF			= 768,
	IDE_LIFETBL_HAZARD			= 769,
	IDE_LIFETBL_SEHAZARD		= 771,
	
// Echo 5/12/04 Add for Correlation Coefficient functions
	IDE_CORRSTATS_N				= 790, 
	IDE_CORRSTATS_MEAN			= 795,
	IDE_CORRSTATS_SD			= 800,
	IDE_CORRSTATS_MIN			= 805,
	IDE_CORRSTATS_MAX			= 810,

//---Echo 5/14/04 Add for Power & Sample Size functions
	IDE_POWEROPTS_MEAN1			= 815,
	IDE_POWEROPTS_MEAN2			= 820,
	IDE_POWEROPTS_SD			= 825,

	IDE_ANOVAPOWEROPTS_LEVEL	= 830,
	IDE_ANOVAPOWEROPTS_CSS		= 835,
	IDE_ANOVAPOWEROPTS_SD		= 840,

//Echo 5/19/04 Add for 2 way ANOVA table
	IDE_ANOVA2TABLE_DOF			= 845,
	IDE_ANOVA2TABLE_SSQ			= 850,
	IDE_ANOVA2TABLE_MEANSQ		= 855,
	IDE_ANOVA2TABLE_FVALUE		= 860,
	IDE_ANOVA2TABLE_PVALUE		= 865,

	/// Iris 8/14/2008 QA80-12017-S2 ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
	IDE_NOTES_NUM_PARAMS		= 866,
	IDE_NOTES_NUM_DERIVED_PARAMS= 867,
	///END ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
	
	//--- CPY 6/10/04
	IDE_NOTES_DESCRIPTION		= 868,
	IDE_NOTES_USERNAME			= 869,
	IDE_NOTES_CREATION_TIME		= 870,
	IDE_NODES_AUTOUPDATE_MODE	= 871,
	/// ML 7/20/2005 FITTING_FUNCTION_FORMULA_IN_REPORT
	IDE_NOTES_EQUATION			= 872,
	/// end FITTING_FUNCTION_FORMULA_IN_REPORT
	//---
	///Echo 9/8/06 ATTN_NOTE_IN_REPORT
	IDE_NOTES_ATTN				= 873,
	///end ATTN_NOTE_IN_REPORT
	///Arvin 10/27/06 FITTING_FUNCTION_MODEL_IN_REPORT
	IDE_NOTES_MODEL				= 874,
	///end FITTING_FUNCTION_MODEL_IN_REPORT
	
	/// Iris 07/28/2007 v8.0572 ADD_DATA_MODE_IN_REPORT
	IDE_NOTES_DATA_MODE			= 875,
	///end ADD_DATA_MODE_IN_REPORT
	
	/// Iris 05/14/2007 v8.0617 SHOW_WEIGHT_IN_OUTPUT_FOR_LR_PR_MR
	IDE_NOTES_WEIGHT			= 876,
	///end SHOW_WEIGHT_IN_OUTPUT_FOR_LR_PR_MR
	
	IDE_NOTES_NUM_DATASET		= 877, /// Iris 8/14/2008 QA80-12017-S2 ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
	
//Echo 7/12/04 Add for Non-parameter hypothesis
	IDE_NPHSUMM_N				= 878, 
	IDE_NOTES_METHOD			= 879, 			///Kyle 04/09/2009 QA80-3224-P2 SHOW_SELECTED_METHOD_IN_REPORT_NOTES
	IDE_NPHSUMM_SD				= 880,
	IDE_NPHSUMM_SE				= 882,
	IDE_NPHSUMM_MEDIAN			= 884,
	IDE_NPHSUMM_MIN				= 886,
	IDE_NPHSUMM_MAX				= 888,
	
	IDE_NPHFREQS_N				= 887,
	IDE_NPHFREQS_LEMD			= 889,
	IDE_NPHFREQS_GTMD			= 891,
	
	IDE_NPHRANKS_N				= 890,
	IDE_NPHRANKS_MEANRANK		= 892,
	IDE_NPHRANKS_SUMRANK		= 894,
	
	IDE_NPHSTATS_STAT			= 896,
	IDE_NPHSTATS_Z				= 898,
	IDE_NPHSTATS_DOF			= 899,
	IDE_NPHSTATS_PROB			= 900,
	
	IDE_RESIDUAL_CURVE_BOOK		= 901,
	IDE_RESIDUAL_CURVE_SHEET	= 902,	
	IDE_RESULT_CURVE_BOOK		= 903,
	IDE_RESULT_CURVE_SHEET		= 904,	
	IDE_RESULT_CURVE_BRANCH		= 905, /// YuI 09/27/05
	IDE_RESULT_CURVE_COLOR		= 906, /// YuI 09/27/05
	IDE_REOPRT_BOOK				= 907,
	IDE_REPORT_SHEET			= 908,
	IDE_REPORT_COLUMN			= 909, /// Iris 4/18/2007 v8.0603 ADD_OUTPUT_DEST_COL_OPTION
	IDE_REPORT_CUSTOM_BOOK_SHEET= 910,
	IDE_PARTIAL_CURVE_BOOK		= 911,
	IDE_PARTIAL_CURVE_SHEET		= 912,
	
	IDE_RESULT_DATA_BRANCH 		= 921,  ///Iris 3/15/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
	IDE_RESULT_DATA_COL			= 922,	
	IDE_RESULT_DATA_XCOL		= 923,
	IDE_RESULT_DATA_YCOL		= 924,
	IDE_RESULT_DATA_ZCOL		= 925,
	///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
	IDE_FIND_XY_BOOK			= 926,
	IDE_FIND_XY_SHEET			= 927,	
	///End MODIFICATION_OUTPUT_BRANCH

	IDE_REPORT_ADD_TO_RESULTS_LOG = 928,
	IDE_REPORT_DUMP_SCRIPTWIN	= 935,
	IDE_REPORT_DUMP_NOTESWIN	= 936,
//	IDE_REPORT_INSERT_COLUMNS	= 924,	//Forest 09/11/04
	IDE_REPORT_CREATE_OPTION	= 937,
	
	IDE_KEEP_SESSION_GRAPH      = 938,  ///Iris 4/19/05
	
	//IDE_PASTE_FORMULA_TO_GRAPH	= 930,  ///DSC 2/4/05
	IDE_PASTE_RESULT_TABLES_TO_GRAPH = 940, ///Iris 8/16/05
	
	
	IDE_2DBINNING_MATRIX		= 945,  ///Iris 11/26/04
	
	//NormTestOptions
	IDE_KOLM_PARAS				= 945, 
	IDE_KOLM_MEAN				= 950,
	IDE_KOLM_VAR				= 955,
	IDE_NORM_LILLE				= 960,
	IDE_NORM_SHAWILK			= 965,

	IDE_DESC_STATS				= 970,
	IDE_TREE_ALPHA              = 971,   //--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
	//ANOVA Mean Comparison
	IDE_MEANCOMP_ALPHA			= 973,  /// Iris 12/13/05
	IDE_MEANCOMP_BONF			= 975,
	IDE_MEANCOMP_SCHE			= 980,
	IDE_MEANCOMP_TUKEY			= 985,
	IDE_MEANCOMP_DUNNE			= 990,
	/// Iris 12/14/05 ADD_CONTROL_LEVEL_FOR_DUNNETT_MEAN_COMP
	IDE_MEANCOMP_DUNNE_LEVEL1   = 991,
	IDE_MEANCOMP_DUNNE_LEVEL2   = 992,	
	///End ADD_CONTROL_LEVEL_FOR_DUNNETT_MEAN_COMP
	IDE_MEANCOMP_FISHLSD 		= 995,
	IDE_MEANCOMP_DUNNSIDAK		= 1000,
	IDE_MEANCOMP_HOLMBONF		= 1005,
	IDE_MEANCOMP_HOLMSIDAK		= 1010,
	
	//ANOVA Equal Variance
	IDE_EQUAVAR_ALPHA			= 1014,	 //--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
	IDE_EQUAVAR_LEVEN			= 1015,
	IDE_EQUAVAR_LEVEN2			= 1020,
	IDE_EQUAVAR_BROWNFORS		= 1025,
	
	//2 Way ANOVA 
	IDE_ANOVA2_INTERACT			= 1030,
	IDE_ANOVA2_DESC_A			= 1035,
	IDE_ANOVA2_DESC_B			= 1040,
	IDE_ANOVA2_DESC_ALL			= 1045,
	IDE_ANOVA2_DESC_INTERACT	= 1050,
	
	///DG 4/21/05
	//XYZ Gridding to Matrix
	IDE_XYZ2MAT_SOURCE			= 1060,
	
	IDE_XYZ2MAT_EXAM_DATA		= 1065,
	///---Sim 09-25-2009 QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION
	IDE_XYZ2MAT_PRECISION		= 1070,
	IDE_XYZ2MAT_X_PRECISION		= 1071,
	IDE_XYZ2MAT_Y_PRECISION		= 1072,
	///---END QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION
	IDE_XYZ2MAT_REMOVE_DUPL_BY	= 1075,
	
	///Jack 9-19-2008 QA80-12191  SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS
	IDE_XYZ2MAT_XSTEPTOLERANCE	= 1076,
	IDE_XYZ2MAT_YSTEPTOLERANCE	= 1077,
	///End SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS

	
	IDE_XYZ2MAT_CONVERT_TO_MAT	= 1080,
	IDE_XYZ2MAT_PARAMETERS		= 1085,
	IDE_XYZ2MAT_PARA_ROWS		= 1090,
	IDE_XYZ2MAT_PARA_COLUMNS	= 1092,
	IDE_XYZ2MAT_PARA_QILF		= 1094,
	IDE_XYZ2MAT_PARA_WFLF		= 1096,
	IDE_XYZ2MAT_PARA_SEARCH_RADIUS	= 1098,
	IDE_XYZ2MAT_PARA_MINI_POINTS	= 1100,
	///DG SMOOTHING_VAL_FOR_DIFF_METHOLD
	//IDE_XYZ2MAT_PARA_SMOOTHING		= 1102,
	IDE_XYZ2MAT_PARA_BS_SMOOTHING	= 1101,
	IDE_XYZ2MAT_PARA_CORRE_SMOOTHING	= 1102,
	IDE_XYZ2MAT_PARA_TPS_SMOOTHING	= 1103,
	///end SMOOTHING_VAL_FOR_DIFF_METHOLD
	IDE_XYZ2MAT_PARA_EXTRAPOLATION	= 1104,
	IDE_XYZ2MAT_PARA_OUTSIDE_VAL	= 1106,
	IDE_XYZ2MAT_PARA_TOLERANCE		= 1108,
	IDE_XYZ2MAT_PARA_MAXI_POINTS	= 1109, ///---Sim 09-16-2009 QA81-11497-P7 ADD_MAXIMUM_FOR_RANDOM_KRIGING_METHOD
	
	IDE_XYZ2MAT_MAT_RANGE			= 1110,
	IDE_XYZ2MAT_MAT_RANGE_XMIN		= 1112,
	IDE_XYZ2MAT_MAT_RANGE_XMAX		= 1114,
	IDE_XYZ2MAT_MAT_RANGE_XSTEP		= 1116,
	IDE_XYZ2MAT_MAT_RANGE_YMIN		= 1118,
	IDE_XYZ2MAT_MAT_RANGE_YMAX		= 1120,
	IDE_XYZ2MAT_MAT_RANGE_YSTEP		= 1122,
	///Kevin 10/08/05 ADD_DATA_ID_FOR_ROUND_LIMIT
	IDE_XYZ2MAT_ROUND_LIMIT			= 1123,
	///ADD_DATA_ID_FOR_ROUND_LIMIT
	
	IDE_XYZ2MAT_ADVANCED_OPERATIONS	= 1130,
	IDE_XYZ2MAT_SELECT_RANGE		= 1135,
	IDE_XYZ2MAT_RANGE_XMIN			= 1136,
	IDE_XYZ2MAT_RANGE_XMAX			= 1137,
	IDE_XYZ2MAT_RANGE_YMIN			= 1139,
	IDE_XYZ2MAT_RANGE_YMAX			= 1140,
	
	IDE_XYZ2MAT_MISSINGVAL					= 1150,
	IDE_XYZ2MAT_MISSINGVAL_REPLACEBY		= 1152,
	IDE_XYZ2MAT_MISSINGVAL_LEFT_STEPS		= 1154,
	IDE_XYZ2MAT_MISSINGVAL_RIGHT_STEPS		= 1156,
	IDE_XYZ2MAT_MISSINGVAL_TOP_STEPS		= 1158,
	IDE_XYZ2MAT_MISSINGVAL_BOTTOM_STEPS		= 1160,
	IDE_XYZ2MAT_MISSINGVAL_IGNORE_LEFT		= 1162,
	IDE_XYZ2MAT_MISSINGVAL_IGNORE_RIGHT		= 1164,
	IDE_XYZ2MAT_MISSINGVAL_IGNORE_TOP		= 1166,
	IDE_XYZ2MAT_MISSINGVAL_IGNORE_BOTTOM	= 1168,
	
	IDE_XYZ2MAT_PREVIEW_PLOT_TYPE	= 1170,
	///end
	
	/// ML 4/12/2005 QA70-7316 FULL_TABLE_AND_ROW_OR_COL_LABELS_PLUS_DATA_LINKS
	IDE_BEGIN_RESERVED			= IDL_BEGIN,
	// Do not use the values in here
	IDE_END_RESERVED			= IDL_END,
	/// end FULL_TABLE_AND_ROW_OR_COL_LABELS_PLUS_DATA_LINKS

	/// Iris 5/25/05 SUPPORT_WEIGHTING_METHODS
	IDE_NLSF_WEIGHTING_METHOD 		= 1200,
	IDE_NLSF_WEIGHTING_A	 		= 1205,
	IDE_NLSF_WEIGHTING_B 			= 1206,
	IDE_NLSF_WEIGHTING_C	 		= 1207,
	///END SUPPORT_WEIGHTING_METHODS
	  
	/// Echo 6/3/05	ROC Curve
	IDE_ROCAREA_AREA				=1210,
	IDE_ROCAREA_SE					=1211,
	IDE_ROCAREA_PROB				=1212,
///Kevin 09/01/05 CHANGE_STATISTICS_NAME
	//IDE_ROCAREA_LCI					=1213,
	//IDE_ROCAREA_UCI					=1214,
	IDE_ROCAREA_LCL					=1213,
	IDE_ROCAREA_UCL					=1214,
///End CHANGE_STATISTICS_NAME

	///Kevin 08/29/05	ROC INPUT
	IDE_RCO_STATE_VALUE				=1215,
	IDE_ROC_THRES_METHOD			=1216,
	IDE_ROC_CURVE					=1217,
	IDE_ROC_STD_ERROR				=1218,
	IDE_ROC_COMPUTATION				=1219,
	IDE_ROC_STATE_LIST				=1220,

	///Liko 6/14/05 CONSTRUCT_GUI_TREE
	IDE_ROC_THRESHOLD				=1225,
	IDE_ROC_WITHLINE				=1226,
	IDE_ROC_CONFIDENCE				=1227,
	IDE_ROC_COORDINATE				=1228,

	///End 

	IDE_ROCCUV_THRES				=1229,
	IDE_ROCCUV_TPP					=1230,
	IDE_ROCCUV_FPP					=1231,
	
	/// Iris 6/04/05 Weighting method
	IDE_FIT_X_WEIGHTING_METHOD		=1300,
	IDE_FIT_Y_WEIGHTING_METHOD		=1305,
	
	IDE_FIT_WITH_X_ERROR_METHOD		=1306,	///Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
	
	/// Iris 6/04/05 Residual branch in Fitting tools
	IDE_FIT_RESIDUALS_BRANCH		=1320,

	IDE_CORRELATION_PEARSON			=1331,	
	IDE_CORRELATION_SPEARMAN		=1332,
	IDE_CORRELATION_KENDALL			=1333,
	IDE_CORRELATION_DESCRIPTIVE		=1334,
	
	IDE_UTEST_NULL					=1335,
	IDE_UTEST_ALTERNATE				=1336,
	IDE_UTEST_N1					=1337,
	IDE_UTEST_N2					=1338,
	IDE_UTEST_PVALUE				=1339,
	
	IDE_RANK_MEDIAN					=1340,
	IDE_RANK_HYPOTHESIS				=1341,
	IDE_RANK_ALTERNATE				=1342,
	
	IDE_PAIRS_DIFFERENCE			=1343,
	IDE_PAIRS_HYPOTHESIS			=1344,
	IDE_PAIRS_ALTERNATE				=1345,
	
	IDE_2DBINNING_CONTROL			=1346,
	IDE_2DBINNING_X					=1347,
	IDE_2DBINNING_XMIN				=1348,
	IDE_2DBINNING_XMAX				=1349,
	IDE_2DBINNING_XINC				=1350,
	IDE_2DBINNING_XINCMIN			=1351,
	IDE_2DBINNING_XINCMAX			=1352,
	IDE_2DBINNING_Y					=1353,
	IDE_2DBINNING_YMIN				=1354,
	IDE_2DBINNING_YMAX				=1355,
	IDE_2DBINNING_YINC				=1356,
	IDE_2DBINNING_YINCMIN			=1357,
	IDE_2DBINNING_YINCMAX			=1358,
	
	//---- CPY 2/21/06 ADD_FOOT_NOTE_TO_TABLE
	IDE_FOOTNOTE_BEGIN				= 1430,
	// all footnotes IDs should be placed here so we can easily find all footnotes later
	
	IDE_FOOTNOTE_END				= 1490,
	//---- end ADD_FOOT_NOTE_TO_TABLE
	
	///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
	IDE_REPORT_NOTES				= 1500,
	IDE_REPORT_INPUT_TABLE			= 1505, 
	IDE_REPORT_MASKED_DATA_TABLE    = 1510, 
	IDE_REPORT_MISSING_DATA_TABLE   = 1515, 
	IDE_RESULT_GRAPHS				= 1520,
	
	///Sophy 12/17/2008 v8.0987d  QA80-12784 ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS
	IDE_HISTOGRAM_BINS_CONFIG_AUTO	= 1525,
	IDE_HISTOGRAM_BINS_CONFIG_SIZE	= 1526,
	IDE_HISTOGRAM_BINS_CONFIG_BEGIN	= 1527,
	IDE_HISTOGRAM_BINS_CONFIG_END	= 1528,
	IDE_HISTOGRAM_GRAPH_NUM_OF_BINS	= 1529,
	///end ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS	
	
	IDE_REPORT_GRAPH_TEMPLATE		= 1545,	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE

	//---------- CPY 5/2/07 QA70-9687 TEMPLATE_FOR_TABLE_INSERT_TO_GRAPH
	// 1521-152? are reserved for report graph ids
	IDE_REOPRT_TABLE_TEMPLATE		= 1549, 
	//----------	
	IDE_REPORT_CUSTOM_TABLE_ROWS    = 1550,
	IDE_REPORT_CUSTOM_TABLE_COLS   = 1555,
	///END MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
	/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
	IDE_REPORT_CUSTOM_TABLE_TITLE	= 1556,
	/// end CUSTOM_TABLES_FOR_FIND_XY
	/// ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS
	IDST_REPORT_CUSTOM_TABLE_THEME	= 1557,
	/// end STYLE_LINKS_WITH_OFFSETS
	/// ML 8/10/2006 REMOVING_CUSTOM_TABLE_FROM_GUI
	IDST_THEME_FOR_TABLE_IN_GRAPH	= 1558,
	/// end REMOVING_CUSTOM_TABLE_FROM_GUI
	/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
	IDST_SEPARATE_RESULT_CURVE_SHEET	= 1559,
	///end OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
	
	///Echo 8/18/05 STRUCTURE_FOR_DIAGNOTIC_RESIDUALS
	IDE_DIAGRESID_RESID				= 1560,
	IDE_DIAGRESID_COOK				= 1565,
	IDE_DIAGRESID_ATKINSON			= 1570,
	///END STRUCTURE_FOR_DIAGNOTIC_RESIDUALS
	
	///Kevin 09/26/05 ADD_DATAID_FOR_KAPLAN_MEIER_ESTIMATE
	IDE_KAPLAN_MEIER_CENSVAL		= 1600,
	IDE_KAPLAN_MEIER_CONFLEVEL		= 1601,
	IDE_KAPLAN_MEIER_SUMMARY		= 1602,	
	IDE_KAPLAN_MEIER_ESTIMATE		= 1603,
	IDE_KAPLAN_MEIER_POLT			= 1604,
	///End ADD_DATAID_FOR_KAPLAN_MEIER_ESTIMATE

	///Echo 11/3/05 STRUCTURE_FOR_SF_COMPARISON
	IDE_SFCOMP_CHISQ				= 1605,
	IDE_SFCOMP_DF					= 1608,
	IDE_SFCOMP_PROB					= 1610,
	///END STRUCTURE_FOR_SF_COMPARISON

	/// Max 11/12/05 STRUCTURE_FOR_RM_ANOVA
	
	// RMANOVADescStats
	//IDE_RMANOVA_GROUP_SIZE			= 1612,
	IDE_RMANOVA_GROUP_MEAN			= 1614,
	IDE_RMANOVA_GROUP_SEM			= 1616,
	IDE_RMANOVA_GROUP_LCL			= 1618,
	IDE_RMANOVA_GROUP_UCL			= 1620,

	// RMANOVARow
	IDE_RMANOVA_SUM_SQUARES			= 1622,
	IDE_RMANOVA_DOF					= 1624,
	IDE_RMANOVA_MEAN_SQUARE			= 1626,
	IDE_RMANOVA_FVALUE				= 1628,
	IDE_RMANOVA_PVALUE				= 1630,
	
	// RMANOVA table
	IDE_RMANOVA_TABLE				= 1632,

	// MultiTestRow
	IDE_MultiTest_Stat				= 1634,
	IDE_MultiTest_FStat				= 1636,
	IDE_MultiTest_HDOF				= 1638,
	IDE_MultiTest_EDOF				= 1640,
	IDE_MultiTest_PVALUE			= 1642,
	
	// MultiTestTable
	IDE_MultiTest_TABLE				= 1644,

	// SphericityStats
	IDE_SPHERIC_WSTAT				= 1646,
	IDE_SPHERIC_CHISQ				= 1648,
	IDE_SPHERIC_DOF					= 1650,
	IDE_SPHERIC_PVALUE				= 1652,

	// EpsilonStats
	IDE_EPSILON_GG					= 1654,
	IDE_EPSILON_HF					= 1656,
	IDE_EPSILON_LB					= 1658,

	/// End STRUCTURE_FOR_RM_ANOVA

	///END CONSTRUCT_GUI_TREE
	
	/// Iris 02/04/06 QA70-8461 ADD_REPLICA_OPTIOINS
	IDE_NL_REPLICA_NUMBER						= 1670,
	IDE_NL_REPLICA_OFFSET						= 1672,
	IDE_NL_REPLICA_NUMPARAM						= 1674,
	///Cheney 2006-1-1 ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
	//IDE_NL_REPLICA_PEAK_CURVE		= 1676,
	//IDE_NL_REPLICA_BASE_LINE		= 1678,
	IDE_NL_REPLICA_INDIVIDUAL_PEAK_CURVE		= 1676,
	IDE_NL_REPLICA_CUMULATIVE_FITTED_CURVE		= 1678,
	IDE_NL_REPLICA_BASE_LINE					= 1680,
	///end ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
	///End ADD_REPLICA_OPTIOINS
	
	///Jospeh 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
	IDE_NL_PARAMS							= 2900,	
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//IDE_NL_PARAMS_APPLY_THEME				= 2905,
	IDE_NL_PARAMS_APPLY_THEME				= 2901,
	IDE_NL_BOUND_APPLY_THEME				= 2902,
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	IDE_NL_PARAMS_AUTO_INIT					= 2906,/// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	IDE_NL_LINEAR_CONSTRAINTS				= 2907,
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	
	/// RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
	#ifndef	NLSF_PARAM_BIGGER_RANGE
	/// end FIX_NLFIT_LIMIT_20_PARAMETERS
	IDE_NL_PARAMS_SHARE_BASE				= 3001,
	IDE_NL_PARAMS_SHARE_END					= 3100,
	
	IDE_NL_PARAMS_FIXED_BASE				= 3101,
	IDE_NL_PARAMS_FIXED_END					= 3200,
	
	IDE_NL_PARAMS_LOWER_BOUNDS_BASE			= 3201,
	IDE_NL_PARAMS_LOWER_BOUNDS_END			= 3300,
	
	IDE_NL_PARAMS_LOWER_BOUNDS_EXCLUSIVE_BASE 	= 3301,
	IDE_NL_PARAMS_LOWER_BOUNDS_EXCLUSIVE_END	= 3400,
	
	IDE_NL_PARAMS_LOWER_BOUNDS_ENABLE_BASE	 	= 3401,
	IDE_NL_PARAMS_LOWER_BOUNDS_ENABLE_END	 	= 3500,
	
	IDE_NL_PARAMS_UPPER_BOUNDS_BASE			 	= 3501,
	IDE_NL_PARAMS_UPPER_BOUNDS_END			 	= 3600,
	
	IDE_NL_PARAMS_UPPER_BOUNDS_EXCLUSIVE_BASE  	= 3601,
	IDE_NL_PARAMS_UPPER_BOUNDS_EXCLUSIVE_END  	= 3700,
	
	IDE_NL_PARAMS_UPPER_BOUNDS_ENABLE_BASE 	 	= 3701,
	IDE_NL_PARAMS_UPPER_BOUNDS_ENABLE_END 	 	= 3800,
	
	IDE_NL_PARAMS_VALUE_BASE 				= 3801,
	IDE_NL_PARAMS_VALUE_END 				= 3900,	
	/// RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
	#endif	//!NLSF_PARAM_BIGGER_RANGE
	/// end FIX_NLFIT_LIMIT_20_PARAMETERS
	
	///End ADD_PARAMETER_SETTING_TO_THEME
	///Arvin 05/08/07 QA70-9498 SCALE_PARAMETER_ERRORS_WITH_CHI_SQR
	IDE_NL_SCALE_ERROR_WITH_CHISQR			= 3910,
	///END SCALE_PARAMETER_ERRORS_WITH_CHI_SQR
	///Arvin 12/08/06 IDS_FOR_RESIDUAL_ANALYSIS
	IDE_RESIDUAL_TYPE						= 3950,
	IDE_RESIDUAL_REGULAR					= 3951,
	IDE_RESIDUAL_STANDARDIZED				= 3952,
	IDE_RESIDUAL_STUDENTIZED				= 3953,
	IDE_RESIDUAL_STUDENTIZED_DELETED		= 3954,
	///END IDS_FOR_RESIDUAL_ANALYSIS
	
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	IDE_REPORT_GRAPH_NUM_COLS				= 4000,
	IDE_REPORT_PLOTS_IN_ONE_GRAPH			= 4005,
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	
	///Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said
	IDE_REPLICA_PARAM_INIT_DIRECTION				= 4011,
	IDE_REPLICA_PARAM_INIT_METHOD					= 4012,
	IDE_REPLICA_PARAM_INIT_LOCAL_POINTS				= 4013,
	IDE_REPLICA_PARAM_INIT_SIZE_OPTIONS				= 4014,
	IDE_REPLICA_PARAM_INIT_WIN_HEIGHT				= 4015,
	IDE_REPLICA_PARAM_INIT_WIN_WIDTH				= 4016,
	IDE_REPLICA_PARAM_INIT_MIN_HEIGHT				= 4017,
	IDE_REPLICA_PARAM_INIT_CONTOUR_MIN_PTS			= 4018,
	IDE_REPLICA_PARAM_INIT_CONTOUR_MAX_AREA			= 4019,
	IDE_REPLICA_PARAM_INIT_CONTOUR_NUM_Z_LEVELS 	= 4020,
	IDE_REPLICA_PARAM_INIT_CONTOUR_MIN_ROUNDNESS 	= 4021,
	///END REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT
	
	///Cheney 2007-6-13 SHOULD_ADD_SIGNIFICANT_DIGIT_IN_PARAMETER_SETTING_NODE	
	/// RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
	#ifndef	NLSF_PARAM_BIGGER_RANGE
	/// end FIX_NLFIT_LIMIT_20_PARAMETERS
	IDE_NL_PARAMS_SIGNIFICANT_DIGIT_BASE	= 4101,
	IDE_NL_PARAMS_SIGNIFICANT_DIGIT_END		= 4200,
	/// RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
	#endif	//!NLSF_PARAM_BIGGER_RANGE
	/// end FIX_NLFIT_LIMIT_20_PARAMETERS
	///end SHOULD_ADD_SIGNIFICANT_DIGIT_IN_PARAMETER_SETTING_NODE	
	
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	IDE_PFM_OUTPUT_SUBTRACTED_DATA_TO       = 4280,
	IDE_PFM_SUBTRACTED_DATA_BOOK			= 4281,
	IDE_PFM_SUBTRACTED_DATA_BOOK_NAME		= 4282,
	IDE_PFM_SUBTRACTED_DATA_BOOK_OLD_NAME	= 4283,
	IDE_PFM_SUBTRACTED_DATA_SHEET			= 4284,
	IDE_PFM_SUBTRACTED_DATA_SHEET_NAME		= 4285,	
	IDE_PFM_SUBTRACTED_DATA_SHEET_OLD_NAME	= 4286,
	
	IDE_PFM_OUTPUT_BASELINE_DATA_TO         = 4290,
	IDE_PFM_BASELINE_DATA_BOOK		        = 4291,
	IDE_PFM_BASELINE_DATA_BOOK_NAME	        = 4292,
	IDE_PFM_BASELINE_DATA_BOOK_OLD_NAME		= 4293,
	IDE_PFM_BASELINE_DATA_SHEET		        = 4294,
	IDE_PFM_BASELINE_DATA_SHEET_NAME        = 4295,
	IDE_PFM_BASELINE_DATA_SHEET_OLD_NAME	= 4296,
	///End OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP

	IDE_PFM_MAX_ITERATIONS					= 4300,
	IDE_PFM_PLOT_CURVES						= 4301,
	IDE_PFM_PLOT_CURVE_TO					= 4302,
	IDE_PFM_ADD_BASELINE					= 4303,
	IDE_PFM_TOLERANCE						= 4305,
	IDE_PFM_CONFIDENCE						= 4310,
	IDE_PFM_PREDICTION						= 4315,	
	IDE_PFM_FIX_BASELINE_PARAM				= 4320,
	IDE_PFM_WEIGHT_METHOD					= 4325,
	IDE_PFM_ENABLE_CONSTRAINTS				= 4330,
	IDE_PFM_CONSTRAINTS						= 4335,
	IDE_PFM_FIT_CONTROLS					= 4340,
	
	///Jasmine 03/26/08 RESERVE_ID_RANGE_FOR_REPORT_FIELD
	IDE_PFM_REPORT_FIELD_BRANCH				= 4350,
	IDE_PFM_REPORT_FIELD_BEGIN				= 4351,
	IDE_PFM_REPORT_FIELD_END				= 4400,
	///Jasmine 03/26/08 REMOVE_PLOT_OPTIONS
	//IDE_PFM_PLOT_REPORT_BRANCH			= 4355,
	//IDE_PFM_WKS_REPORT_BRANCH				= 4360,
	///End REMOVE_PLOT_OPTIONS
	IDE_PFM_REPORT_BRANCH					= 4401,//4380
	///End RESERVE_ID_RANGE_FOR_REPORT_FIELD	
	IDE_PFM_PKC_START 						= 4402,
	IDE_PFM_PKC_PEAKNUM						= 4405,
	IDE_PFM_PKC_PEAKTYPE					= 4410, 
	IDE_PFM_PKC_AREAFIT						= 4415, 
    IDE_PFM_PKC_AREAFIT_TRUNCATED			= 4420, 
    IDE_PFM_PKC_AREAFIT_PERCENTAGE			= 4425, 
   	IDE_PFM_PKC_AREA_INTEGRATE				= 4430,
   	IDE_PFM_PKC_AREA_INTEGRATE_P			= 4435,
   	IDE_PFM_PKC_CENTERMAX					= 4440, 
   	IDE_PFM_PKC_CENTERGRAVITY				= 4445, 
   	IDE_PFM_PKC_MAXHEIGHT					= 4450, 
   	IDE_PFM_PKC_FWHM						= 4455, 
   	IDE_PFM_PKC_VARIANCE					= 4460,
   	IDE_PFM_PKC_SKEW						= 4465,
   	IDE_PFM_PKC_EXCESS						= 4470, 
   	IDE_PFM_PKC_RESOLUTION					= 4475, 
   	IDE_PFM_PKC_MOMENT_METHOD				= 4477,	///Jasmine 05/16/08 MOMENTS_COMPUTE_METHOD
   	IDE_PFM_PKC_MOMENT3						= 4480, 
   	IDE_PFM_PKC_MOMENT4						= 4485, 
   	IDE_PFM_PKC_WIDTHAT						= 4490, 
   	IDE_PFM_PKC_WIDTHAT_PERCENT				= 4492, 
   	IDE_PFM_PKC_AREAABOVE					= 4495,
   	IDE_PFM_PKC_AREAABOVE_PERCENT			= 4497,
   	IDE_PFM_PKC_CUMAREA						= 4500,
   	IDE_PFM_PKC_CUMAREA_PERCENT				= 4502,
	IDE_PFM_PKC_VALUE						= 4505,
	IDE_PFM_PKC_ERROR						= 4510,
	IDE_PFM_PKC_DEPENDENCE					= 4515,
	IDE_PFM_PKC_LCL							= 4520,
	IDE_PFM_PKC_UCL							= 4525,
	
	//------ Folger 11/27/07 ADD_PFW_MORE_INFORMATION_TABLE
	IDE_PFM_XF_NAME							= 4530,
	IDE_PFM_XF_DECSCRIPTION					= 4535,
	IDE_PFM_BASELINE_DATA					= 4540,
	//------

	//------ Sandy 2008-4-23 ADD_NANO_PEAKS_CHARACTERIZATION_DATA_ID
    IDE_NANO_PKC_AREAFIT_TRUNCATED			= 4545,
    IDE_NANO_PKC_AREAFIT_PERCENTAGE			= 4550,
    IDE_NANO_PKC_AREA_INTEGRATE				= 4555,
    IDE_NANO_PKC_AREA_INTEGRATE_P			= 4560,
    IDE_NANO_PKC_CENTER_X					= 4565,
    IDE_NANO_PKC_CENTER_Y					= 4570,
    IDE_NANO_PKC_CENTER_Z					= 4575,
    IDE_NANO_PKC_XFWHM						= 4580,
    IDE_NANO_PKC_YFWHM						= 4582,
    IDE_NANO_PKC_AREAABOVE					= 4585,
    IDE_NANO_PKC_CUMAREA					= 4590,
	//-------

	/// RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
	#ifdef	NLSF_PARAM_BIGGER_RANGE
	IDE_NL_PARAMS_SHARE_BASE					= 5000,
	IDE_NL_PARAMS_SHARE_END						= 5999,
	
	IDE_NL_PARAMS_FIXED_BASE					= 6000,
	IDE_NL_PARAMS_FIXED_END						= 6999,
	
	IDE_NL_PARAMS_LOWER_BOUNDS_BASE				= 7000,
	IDE_NL_PARAMS_LOWER_BOUNDS_END				= 7999,
	
	IDE_NL_PARAMS_LOWER_BOUNDS_EXCLUSIVE_BASE 	= 8000,
	IDE_NL_PARAMS_LOWER_BOUNDS_EXCLUSIVE_END	= 8999,
	
	IDE_NL_PARAMS_LOWER_BOUNDS_ENABLE_BASE	 	= 9000,
	IDE_NL_PARAMS_LOWER_BOUNDS_ENABLE_END	 	= 9999,
	
	IDE_NL_PARAMS_UPPER_BOUNDS_BASE			 	= 10000,
	IDE_NL_PARAMS_UPPER_BOUNDS_END			 	= 10999,
	
	IDE_NL_PARAMS_UPPER_BOUNDS_EXCLUSIVE_BASE  	= 11000,
	IDE_NL_PARAMS_UPPER_BOUNDS_EXCLUSIVE_END  	= 11999,
	
	IDE_NL_PARAMS_UPPER_BOUNDS_ENABLE_BASE 	 	= 12000,
	IDE_NL_PARAMS_UPPER_BOUNDS_ENABLE_END 	 	= 12999,
	
	IDE_NL_PARAMS_VALUE_BASE 					= 13000,
	IDE_NL_PARAMS_VALUE_END 					= 13999,	
	
	IDE_NL_PARAMS_SIGNIFICANT_DIGIT_BASE		= 14000,
	IDE_NL_PARAMS_SIGNIFICANT_DIGIT_END			= 14999,
	
	/// Iris 4/21/2008 QA80-11371 SAVE_FIX_VALUE_WITH_TOGETHER_WITH_FIX_STATUS
	IDE_NL_PARAMS_FIXED_VALUE_BASE				= 15000,
	IDE_NL_PARAMS_FIXED_VALUE_END				= 15999,
	///END SAVE_FIX_VALUE_WITH_TOGETHER_WITH_FIX_STATUS

	#endif	//NLSF_PARAM_BIGGER_RANGE
	/// end FIX_NLFIT_LIMIT_20_PARAMETERS

	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	IDE_NL_THEME_FILTER_FUNC					= 17000,
	IDE_NL_THEME_FILTER_PARAMS					= 17001,
	IDE_NL_THEME_FILTER_FIXED					= 17002,
	IDE_NL_THEME_FILTER_SHARE					= 17003,
	IDE_NL_THEME_FILTER_ULB						= 17004,
	IDE_NL_THEME_FILTER_CONSTRAINTS				= 17005,
	IDE_NL_THEME_FILTER_SCRIPT					= 17006,
	IDE_NL_THEME_FILTER_AUTO_PARAM_INIT			= 17007,
	IDE_NL_THEME_FILTER_ENABLE_LINEAR_CONSTRAINTS	= 17008,
	IDE_THEME_FILTER_OTHER						= 17009,
	IDE_NL_THEME_FILTER_CODES_PARAINIT			= 17010,
	///------ Folger 12/18/09 QA81-14859 THEME_SETTINGS_SUPPORT_APPLY_FIXED_STATUS_ONLY
	IDE_NL_THEME_FILTER_FIXED_ONLY				= 17011,
	///------ End THEME_SETTINGS_SUPPORT_APPLY_FIXED_STATUS_ONLY
	///---END QA80-11371 THEME_SAVING_OPTIONS
	
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	IDE_REOPRT_BOOK_NAME						= 20000,
	IDE_REOPRT_BOOK_OLD_NAME					= 20001,
	IDE_REPORT_SHEET_NAME						= 20005,
	IDE_REOPRT_SHEET_OLD_NAME					= 20006,
	IDE_RESULT_CURVE_BOOK_NAME  				= 20010,
	IDE_RESULT_CURVE_BOOK_OLD_NAME				= 20011,
	IDE_RESULT_CURVE_SHEET_NAME 				= 20015,
	IDE_RESULT_CURVE_SHEET_OLD_NAME				= 20016,
	IDE_RESIDUAL_CURVE_BOOK_NAME				= 20020,
	IDE_RESIDUAL_CURVE_BOOK_OLD_NAME			= 20021,
	IDE_RESIDUAL_CURVE_SHEET_NAME 				= 20025,
	IDE_RESIDUAL_CURVE_SHEET_OLD_NAME			= 20026,
	IDE_FIND_XY_BOOK_NAME						= 20030,
	IDE_FIND_XY_BOOK_OLD_NAME					= 20031,
	/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	IDE_FIND_XY_SHEET_NAME2						= 20034,
	/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	IDE_FIND_XY_SHEET_NAME 						= 20035,
	IDE_FIND_XY_SHEET_OLD_NAME 					= 20036,
	/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	IDE_FIND_XY_SHEET_OLD_NAME2					= 20037,
	/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	IDE_PARTIAL_BOOK_NAME						= 20040,
	IDE_PARTIAL_BOOK_OLD_NAME					= 20041,
	IDE_PARTIAL_SHEET_NAME 						= 20045,
	IDE_PARTIAL_SHEET_OLD_NAME 					= 20046,
	///END ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	
	///Iris 4/10/2008 PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	IDE_PFM_REPORT_PEAK_CHAR_TO_BOOK			= 20100,
	IDE_PFM_REPORT_PEAK_CHAR_TO_BOOKNAME		= 20105,
	IDE_PFM_REPORT_PEAK_CHAR_TO_SHEET			= 20110,
	IDE_PFM_REPORT_PEAK_CHAR_TO_SHEETNAME		= 20115,
	///end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	
	///Sandy 2008-4-13 PA_THEME_SETTING
	IDE_PA_THEME_FILTER_BASE_ANCHOR				= 20120,
	IDE_PA_THEME_FILTER_BASE_DATA				= 20125,
	IDE_PA_THEME_FILTER_PEAK_DATA				= 20130,
	//IDE_PA_THEME_FILTER_OTHER_SETTINGS			= 20135,
	//end PA_THEME_SETTING
	
	IDE_OUTPUT_MANAGER_POINTER					= 20150, /// Iris 4/14/2008 FAIL_TO_GET_OUTPUT_POINTER_IN_PA_FIT		
	IDE_OPERATION_POINTER						= 20155, /// Iris 4/14/2008 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
	
	//------ Folger 12/03/08 QA80-12701 v8.0982 THEME_SETTING_CONTROL_FOR_BASELINE_FUNCTION_APPLIED_IN_PA_FIT
	IDE_PA_THEME_FILTER_BASE_FUNC_USING			= 20160,
	IDE_PA_THEME_FILTER_BASE_FUNC_ACTUAL_VALUE	= 20165,
	//------
	
	IDE_NOTES_SPECIAL_INPUT_HANDLING			= 21000, /// Iris 3/12/2009 QA80-13268 NOTES_TABLE_ADD_SPECIAL_INPUT_HANDLING
	
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	IDE_REPORT_GRAPH_OPTIONS_BEGIN				= 21010,
	IDE_REPORT_GRAPH_OPTIONS_END				= 21080,
	///END OP_DLG_NEW_STRUCTURE
/// EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///
/// Values 0x8000 to 0x8FFF are being reserved for dialogs and windows.
/// The range can increase or decrease as long as existing IDs do not change.
///	This range has also been reserved in HelpID.h.  If you change the range then
/// please also update HelpID.h.
///
	IDST_DLG_ASCIMP_OPTIONS			= 0x00008000,
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
/// end UNIQUE_ID_FOR_HELP_WITH_GETN_BOX

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///////////////////////       Section 2, report values      //////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////	

	IDST_FIT_X					= 0x00010010,
	IDST_FIT_Y					= 0x00010012,
	///Cheney 2006-9-1 ADD_FOR_LINEAR_FIT_CONCATENATE_AVE_REPLICA
	IDST_FIT_AVEX				= 0x00010014,
	IDST_FIT_AVEY				= 0x00010016,
	IDST_FIT_AVEERR				= 0x00010018,
	///end ADD_FOR_LINEAR_FIT_CONCATENATE_AVE_REPLICA
	IDST_FIT_LCB				= 0x00010044, /// Iris 2/17/06 increase Fit Y ID range, multiple Fit Y for replica or multiplicity function
	IDST_FIT_UCB				= 0x00010046,
	IDST_FIT_LPB				= 0x00010048,
	IDST_FIT_UPB				= 0x0001004A,
	IDST_FIT_RESIDUES			= 0x0001004C,
	IDST_FIT_Z					= 0x0001004E,   /// Iris 6/11/05 NLSF_SUPPORT_XYZ_DATA
	
	/// Iris 5/29/2008 QA80-11620 v8.0873 FIX_NO_RECALCULATE_ON_OUTPUT_MATRIX
	IDST_XYZ2MAT				= 0x00010060,
	IDST_XYZ2MAT_DATA			= 0x00010065,
	///end FIX_NO_RECALCULATE_ON_OUTPUT_MATRIX
	
	IDST_INDIVIDUAL_FIT_X		= 0x00010100,	///------ Folger 01/04/09 QA80-12962 MORE_WORK_ON_GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA
	
	//--- CPY 6/28/04
	// bin wks, anova table etc, when 2D table, we then enumerate col of same type by the
	// following start index
	IDST_SUB1_START				= 0x0001A000, 
	IDST_SUB2_START				= 0x0001B000,
	IDST_SUB3_START				= 0x0001C000,
	IDST_SUB4_START				= 0x0001D000,
	IDST_SUB5_START				= 0x0001E000,
	IDST_SUB6_START				= 0x0001F000,
	IDST_SUB7_START				= 0x00020000,
	/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
	IDST_SUB8_START				= 0x00021000,
	IDST_SUB9_START				= 0x00022000,
	IDST_SUB10_START			= 0x00023000,				///Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
	/// end Z_IN_REPORT_TABELS
	//---

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///////////////////////       Section 3, various labels     //////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

	IDE_TITLE					= 0x00100000,
	IDE_SUB_TITLE				= 0x00100005,
	IDE_HEADING1				= 0x00100010,
	IDE_HEADING2				= 0x00100015,
	IDE_IMAGE					= 0x00100018,
	IDE_FOOTER1					= 0x0010001B,
	IDE_FOOTER2					= 0x0010001C,

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
/////////////////////      Section 4, struct and tables     //////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
	IDST_TREE_BRANCH_MASK				= 0x00200000,
	IDST_DESC_STATS_OPTIONS				= 0x00200001,
	IDST_DESC_STATS_MOMNTS_OPTNS		= 0x00200002,
	IDST_REPORT_NOTES					= 0x00200005,
	IDST_REPORT_INPUT_TABLE				= 0x00200008,

	IDST_DATA_SELECTION					= 0x0020000A,
	IDST_INPUT_DATA_OPTIONS				= 0x0020000B,
	IDST_REPORT_CURVE_OPTIONS			= 0x0020000C,
	IDST_RESIDUAL_CURVE_OPTIONS			= 0x0020000D,  	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	IDST_REPORT_SHEET_OPTIONS			= 0x0020000E,
	IDST_FIND_XY_OPTIONS	     		= 0x0020000F,	///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH	
	IDST_FIT_STATS_OPTIONS				= 0x00200010,
	IDST_FIT_PARAMS_OPTIONS				= 0x00200011,
	IDST_FIT_QUANTITIES_OPTIONS			= 0x00200012,
	IDST_PARTIAL_CURVE_OPTIONS			= 0x00200013,	///Arvin 12/01/06 REPORT_PARTIAL_REGRESSION_DATA_IN_SEP_REPORT_SHEET
	IDST_PFM_REPORT_PEAK_CHAR_TO		= 0x00200014,	
	
	IDST_RANGE_RESULTS					= 0x00200015,
	IDST_QUANTILE_OPTIONS				= 0x00200020,
	IDST_QUANTILE_RESULTS				= 0x00200025,
	IDST_FREQ_COUNT_OPTIONS				= 0x00200030,
	IDST_LR_OPTIONS						= 0x00200035,
	IDST_RESULT_CURVE_OPTIONS			= 0x00200040,
	IDST_RESIDUAL_TYPE_OPTIONS			= 0x00200041,	///Arvin 12/08/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	///Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said
	IDST_REPLICA_PARAM_INIT_OPTIONS		= 0x00200045,
	///END REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT	
	IDST_NLSF_FUNC_SEL_OPTIONS			= 0x00200050,
	IDST_NLSF_FITTED_CURVE_SETTING  	= 0x00200051,
	IDST_NLSG_ADVANCED_OPERATIONS		= 0x00200052,	///Danice 11/10/04
	IDST_NLSF_OPTIONS					= 0x00200054,
	IDST_NLSF_CODES						= 0x00200056,
	IDST_NLSF_DERIV_OPTIONS				= 0x00200058,

	IDST_RESULT_CURVES					= 0x0020005A, // separate out fit curves from calculation branch //---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	IDST_RESIDUAL_CURVES				= 0x00200060, /// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	IDST_RESULT_OUTPUT					= 0x00200065, ///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	IDST_FIT_CONTROL					= 0x00200070,
	IDST_HYPOT_TEST_OPTIONS				= 0x00200075,
	IDST_F_VAR_RESULTS					= 0x00200100,	
	IDST_NORM_TEST_CONTROL				= 0x00200102,
	IDST_NORM_TEST_RESULTS				= 0x00200105,
	IDST_KOLM_CONTROL					= 0x00200107,
	IDST_ANOVA_DESC_STATS				= 0x00200110,
	IDST_CALCULATION_RESULTS			= 0x00200112, // main report table
	IDST_TTEST_CONTROL					= 0x00200114,
	IDST_CHISQ_CONTROL					= 0x00200116,
	IDST_POWER_CONTROL					= 0x00200118,
	IDST_TTEST2_CONTROL					= 0x00200120,
	IDST_FTEST_CONTROL					= 0x00200122,
	IDST_ANOVA_MEAN_COMP				= 0x00200124,
	IDST_ANOVA_EQUA_VAR					= 0x00200126,	
	
	//--- CPY 6/10/04 ADD_REPORT_OPTIONS
	
	IDST_OUTPUT_RESULTS_OPTIONS			= 0x00200150, // Forest 09/09/04, SAVE_SETTING_ON_ALL_LEVELS, output options should use the same ID so that it can copy and paste
	/*
	IDST_REPORT_OPTIONS_DESC_STATS		= 0x00200150,
	IDST_REPORT_OPTIONS_LR				= 0x00200152,
	IDST_REPORT_OPTIONS_PR				= 0x00200154,
	IDST_REOPRT_OPTIONS_SMOOTHING		= 0x00200156,
	IDST_REPORT_OPTIONS_TTEST  			= 0x00200158, // Iris 9/09/04
	*/
	//---
	
	//---- CPY 8/3/04
	IDST_SMOOTHING_OPTIONS				= 0x00200300,
	
	//----

	//Output ID
	//---- Iris 9/09/04 Clean up output ID altogether
	IDST_DESC_STATS_RESULTS					= 0x00201020,
	
	IDST_DESC_SUMMARY_RESULTS               = 0x00202015,
	
	IDST_DESC_STATS_EXTREME_VALS			= 0x00201025, /// Iris 01/09/05 QA70-6367 ADD_EXTREME_VALUES
	
	IDST_T_TEST_STATS_RESULTS				= 0x00201030, // for one sample t test
	IDST_T_TEST_DESC_STATS_1SAMPLE_RESULTS  = 0x00201040,
	IDST_T_TEST_RESULT						= 0x00201050,		
	IDST_T_TEST_MEAN_1SAMPLE_RESULTS		= 0x00201060,
	IDST_CHI_SQ_VAR_1SAMPLE_RESULTS			= 0x00201070,
	IDST_T_TEST_VARIANCE_1SAMPLE_RESULTS    = 0x00201080,
	IDST_T_TEST_POWERS_1SAMPLE_RESULTS		= 0x00201090,
	IDST_T_TEST_ACTUAL_POWERS_1SAMPLE		= 0x00201095, 
	
	IDST_T_TEST_DESC_STATS_2SAMPLE_RESULTS  = 0x00201100,
	IDST_T_TEST_2SAMPLES_RESULT				= 0x00201110,		
	IDST_T_TEST_MEAN_2SAMPLE_RESULTS		= 0x00201120,
	IDST_CHI_SQ_VAR_2SAMPLE_RESULTS			= 0x00201130,
	IDST_T_TEST_VARIANCE_2SAMPLE_RESULTS    = 0x00201140,
	IDST_T_TEST_POWERS_2SAMPLE_RESULTS		= 0x00201150,
	
	IDST_REG_STATS_RESULTS					= 0x00201200,
	IDST_NLSF_STATS_RESULTS					= 0x00201210,
	IDST_REG_ANOVA_ROW						= 0x00201220,
	//---- CPY 10/14/04 QA70-7029 COR_CORR_USE_MATRIX
//	IDST_REG_COV							= 0x00201230,
//	IDST_REG_CORR							= 0x00201240,
    IDST_REG_COV_TABLE						= 0x00201230,
    IDST_REG_COVS							= 0x00201231, // we will just enumerate from this for each fit cuve subtable, no need to be unique when compared to other IDS
    IDST_REG_CORR_TABLE						= 0x00201240,
    IDST_REG_CORRS							= 0x00201241, 
    //----
	
    IDST_REPORT_MASKED_DATA_TABLE			= 0x00201250,
    IDST_REPORT_MASKED_DATA_TABLES			= 0x00201251,

	/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
    IDST_REPORT_MISSING_DATA_TABLE			= 0x00201270,
    IDST_REPORT_MISSING_DATA_TABLES			= 0x00201271,
	/// end GETTING_MISSING_VALUES_AND_ROWS
	///Arvin 06/15/07 WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
	IDST_STAT_HISTOGRAM_TABLE				= 0x00201290,
    IDST_STAT_BOX_CHART_TABLE				= 0x00201295,
    ///end WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
	IDST_BIN_WKS							= 0x00201300,
	IDST_RESULT_GRAPHS						= 0x00201310,
	IDST_FIT_CURVES_TABLE					= 0x00201400,
	//IDST_FIT_CURVES							= 0x00201410, // we will just enumerate from this for each fit cuve subtable, no need to be unique when compared to other IDS	///Iris 4/14/05, move fit curve id
	IDST_FIT_PARAMETER						= 0x00201420,
	IDST_FIT_PARAMETERS_SUMMARY				= 0x00201430,  /// Iris 01/09/2007 v8.0539 ADD_PARAMTERS_SUMMARY_TABLE
	IDST_FIT_PEAKS							= 0x00201440,  ///Sandy 2006-10-18 MULTIPEAK_FIT
	IDST_ANOVA_TABLE						= 0x00201500,
	IDST_RESIDUAL_DATA_TABLE				= 0x00201505, ///Iris 4/01/05 FIT_REGRESSION_PLOTS
	//IDST_ANOVA_DESC_STATS					= 0x00201505, ///Echo 9/30/04 SUCH_ITEM_EXITS_ALREADY
	IDST_ANOVAS								= 0x00201510, // we will just enumerate from this for each ANOVA subtable, no need to be unique when compared to other IDS
    IDST_ANOVAS_OVERALL						= 0x00201515,
    IDST_ANOVAS_FIT_STATS					= 0x00201520,
    IDST_ANOVAS_MEAN_COMP					= 0x00201525,
    IDST_ANOVAS_MEAN_COMP_BONFERON			= 0x00201530,
    IDST_ANOVAS_MEAN_COMP_TUKEY			= 0x00201535,
    IDST_ANOVAS_MEAN_COMP_SCHEFFE			= 0x00201540,
    IDST_ANOVAS_TEST_EQUAL_VAR				= 0x00201545,
    IDST_ANOVAS_TEST_EQUAL_VAR_LEVENE		= 0x00201550,
    IDST_ANOVAS_TEST_EQUAL_VAR_LEVENESQ		= 0x00201555,
    IDST_ANOVAS_TEST_EQUAL_VAR_BROWN		= 0x00201560, 
    ///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
    //IDST_ANOVAS_ACT_POWER					= 0x00201565,
    //IDST_ANOVAS_HYPOTPOWER					= 0x00201566, ///Iris 11/10/04
    IDST_ANOVAS_POWER_TABLE					= 0x00201565,
    ///end CLEAN_ANOVA_TOOLS_CODE
	IDST_ANOVA_BAR_CHART_WKS_TABLE  		= 0x00201569, ///Iris 12/22/05
 	IDST_ANOVA_MEAN_SD_WKS_TABLE			= 0x00201570, ///Iris 12/28/04
    IDST_ANOVA_MEAN_SE_WKS_TABLE			= 0x00201571, 
    IDST_ANOVA_MEAN_COMP_WKS_TABLE			= 0x00201572,

	///Iris 10/18/04
	IDST_ANOVA2_DESC_STATS_SUBLEVEL			= 0x00201600,
	IDST_ANOVA2_DESC_STATS_FACTORA_TABLE	= 0x00201605,
	IDST_ANOVA2_DESC_STATS_FACTORB_TABLE	= 0x00201610,
	IDST_ANOVA2_DESC_STATS_FACTORTO_TABLE	= 0x00201615,
	IDST_ANOVA2_DESC_STATS_FACTORAB_TABLE	= 0x00201620,
	IDST_ANOVA2_SUBLEVEL					= 0x00201625,
	IDST_ANOVA2_OVERALL_TABLE				= 0x00201630,
	IDST_ANOVA2_FIT_STATS_TABLE				= 0x00201635,
	IDST_ANOVA2_MEAN_COMPARE_SUBLEVEL		= 0x00201640,
	IDST_ANOVA2_MEAN_COMPARE_BONF_TABLE		= 0x00201642,
	IDST_ANOVA2_MEAN_COMPARE_TUK_TABLE		= 0x00201644,
	IDST_ANOVA2_MEAN_COMPARE_SCHE_TABLE		= 0x00201646,
	IDST_ANOVA2_MEAN_COMPARE_DUNN_TABLE		= 0x00201648,
	IDST_ANOVA2_MEAN_COMPARE_FISHER_TABLE   = 0x00201650,
	IDST_ANOVA2_MEAN_COMPARE_SIDAK_TABLE 	= 0x00201652,
	IDST_ANOVA2_MEAN_COMPARE_BONHOLM_TABLE  = 0x00201654,
	IDST_ANOVA2_MEAN_COMPARE_SIDAKHOLM_TABLE = 0x00201656,	
	
	IDST_ANOVA2_POWER_TABLE					= 0x00201660,
	IDST_ANOVA2_MEAN_FACTORA_PLOT			= 0x00201665,   ///Iris 12/28/04
	IDST_ANOVA2_MEAN_FACTORB_PLOT			= 0x00201666,
	IDST_ANOVA2_MEAN_FACTORAB_PLOT			= 0x00201667,	
	//----
	
    IDST_FREQ_COUNT_RESULTS					= 0x00201700,
    
    IDST_2D_BINNING_TABLE 					= 0x00201750,
    IDST_2D_BINNING_RESULT					= 0x00201751,
	//----

	//---- CPY 11/10/04 QA70-7121 CUSTOM_REPORT_TABLES
	IDST_REPORT_CUSTOM_TABLE1				= 0x00201790,
	/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	//IDST_REPORT_CUSTOM_TABLE2				= 0x00201791,
	//IDST_REPORT_CUSTOM_TABLE3				= 0x00201792,
	/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	IDST_REPORT_CUSTOM_TABLE_ROWS			= 0x00201795,
	IDST_REPORT_CUSTOM_TABLE_COLS			= 0x00201796,	
	//----
	
	///Iris 11/15/04 QA70-7120 CALIBRATION_REPORT_TABLE
	IDST_REPORT_CALIBRATION_TABLE 			= 0x00201800,
	
	/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	IDST_REPORT_CUSTOM_TABLES2_ROOT			= 0x0020180E,		// used for root of _TABLE2* if multiple needed
	IDST_REPORT_CUSTOM_TABLES3_ROOT			= 0x0020180F,		// used for root of _TABLE3* if multiple needed
	IDST_REPORT_CUSTOM_TABLE2_BEGIN			= 0x00201810,
	IDST_REPORT_CUSTOM_TABLE2_END			= 0x0020184F,		// max of TABLE2S is (IDST_REPORT_CUSTOM_TABLE2_END - IDST_REPORT_CUSTOM_TABLE2_BEGIN + 1)  
	IDST_REPORT_CUSTOM_TABLE3_BEGIN			= 0x00201850,
	IDST_REPORT_CUSTOM_TABLE3_END			= 0x0020188F,		// max of TABLE23 is (IDST_REPORT_CUSTOM_TABLE3_END - IDST_REPORT_CUSTOM_TABLE3_BEGIN + 1)  
	/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA


	/// EJP 12-15-2004 v8.0174 QA70-7252 ADD_ID_TO_ASCIMP
	/// SY 09/20/2005 ASCII_IMPORT_OPTION_ID_REASSIGN
	///	IDST_ASCIMP_DELIMITED					= 0x00201900,
	///	IDST_ASCIMP_DELIMCODE					= 0x00201901,
	///	IDST_ASCIMP_DELIMCHAR					= 0x00201902,
	///	IDST_ASCIMP_COLWIDTHS					= 0x00201903,
	///	IDST_ASCIMP_HEADLINES					= 0x00201904,
	///	IDST_ASCIMP_SUBHEADLINES				= 0x00201905,
	///	IDST_ASCIMP_AUTOSUBHEAD					= 0x00201906,
	///	IDST_ASCIMP_AUTOCOLTYPES				= 0x00201907,
	///	IDST_ASCIMP_TESTLINES					= 0x00201908,
	///	IDST_ASCIMP_IMPORTMODE					= 0x00201909,
	///	IDST_ASCIMP_NUMCOLUMNS					= 0x00201910,
	///	IDST_ASCIMP_PARTIAL						= 0x00201911,
	///	IDST_ASCIMP_PARTIALC1					= 0x00201912,
	///	IDST_ASCIMP_PARTIALC2					= 0x00201913,
	///	IDST_ASCIMP_PARTIALR1					= 0x00201914,
	///	IDST_ASCIMP_PARTIALR2					= 0x00201915,
	///	IDST_ASCIMP_RENAMEWKS					= 0x00201916,
	///	IDST_ASCIMP_APPLYRANGE					= 0x00201917,
	///	IDST_ASCIMP_RENAMECOLS					= 0x00201918,
	///	IDST_ASCIMP_LABEL						= 0x00201919,
	///	IDST_ASCIMP_MAXLABELS					= 0x00201920,
	///	IDST_ASCIMP_LEADZERO					= 0x00201921,
	///	IDST_ASCIMP_NONNUMERIC					= 0x00201922,
	///	IDST_ASCIMP_MAXTESTLINES				= 0x00201923,
	///	IDST_ASCIMP_SKIPROWS					= 0x00201924,
	///	IDST_ASCIMP_READROWS					= 0x00201925,
	///	IDST_ASCIMP_DATEFORMAT					= 0x00201926,
	///	IDST_ASCIMP_SKIPCHARS					= 0x00201927,
	///	IDST_ASCIMP_LONGNAMES					= 0x00201928,
	///	IDST_ASCIMP_UNITS						= 0x00201929,
	///	IDST_ASCIMP_FIRSTPARAMS					= 0x00201930,
	///	IDST_ASCIMP_NUMPARAMS					= 0x00201931,
	///	IDST_ASCIMP_FIRSTSAVE					= 0x00201932,
	///	IDST_ASCIMP_NUMSAVE						= 0x00201933,
	///	IDST_ASCIMP_FLAGS						= 0x00201934,
	///	/// end ADD_ID_TO_ASCIMP
	///	IDST_ASCIMP_NUMSEP						= 0x00201935, /// EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	/// end ASCII_IMPORT_OPTION_ID_REASSIGN
		
	///Iris 4/15/05 FIT_REGRESSION_PLOTS
	IDST_FIT_RESIDUALS_PLOT					= 0x00202000,
	IDST_FIT_RESIDUALS_VERSUS_FITS_PLOT     = 0x00202010,
	IDST_FIT_RESIDUALS_VERSUS_ORDER_PLOT    = 0x00202020,
	IDST_FIT_PARTIAL_REGRESSION_PLOT    	= 0x00202030,
	
	IDST_MR_PARTIAL_CURVE					= 0x00202080, 
	IDST_FIT_CURVES							= 0x00202100,  ///Iris 4/14/05, move fit curve id
	IDST_FIT_RESIDUALS_SCATTER				= 0x00202105,  /// Iris 6/02/05 ADD_RESIDUALS_SCATTER_GRAPH
	IDST_FIT_RESIDUALS_DATA					= 0x00202110,
	IDST_FIT_RESIDUAL_ANALYSIS				= 0x00202115,	///Arvin 12/11/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	IDST_FIT_RESIDUALS_VERSUS_FITS_DATA     = 0x00202120,
	IDST_FIT_RESIDUALS_VERSUS_ORDER_DATA    = 0x00202130,
	IDST_FIT_RESIDUALS_LAG_DATA    			= 0x00202135,  ///Jim 2/24/06 v8.0368 ADD_RESIDUAL_LAG_PLOT_TO_RESIDUALS_PLOTS_BRANCH
	IDST_FIT_PARTIAL_REGRESSION_DATA    	= 0x00202140,
	IDST_FIT_CONFIDENT_PLOT					= 0x00202045,	///Kevin 10/17/05

	// all fit curves related data table must be above IDST_FIT_CURVES_END
	IDST_FIT_CURVES_END						= 0x00202150, //CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	///END FIT_REGRESSION_PLOTS

	IDST_FIT_TEMP_GRAPHS    				= 0x00202150,  /// Iris 5/19/05 QA70-6365 SETUP_FITY_CONFID_PRODI_LINE_COLOR
	IDST_FIT_TEMP_ONE_PICTURE  				= 0x00202160,
	
	///Liko 06/14/2005 	CONSTRUCT_GUI_TREE
	IDST_ROC_CURVE_CONTROL					= 0x00202200,
	IDST_ROC_CONTROL						= 0x00202205,
	IDST_ROC_ERRORANDCONFIDENCE				= 0x00202210,
	///Kevin 08/29/05 ADD_ROC_CURVE_MORE
	IDST_ROC_CURVE							= 0x00202211,
	IDST_ROC_AREA_VALUE						= 0x00202215,
	IDST_ROC_SUMMARY						= 0x00202225,
	IDST_ROC_COORDINATE						= 0x00202270,

	IDST_CORRELATION_CONTROL				= 0x00202300,
	IDST_CORRELATION_TYPE_CONTROL			= 0x00202310,
	
	IDST_UTEST_CONTROL						= 0x00202400,
	
	IDST_RANK_CONTROL						= 0x00202500,
	
	IDST_PAIRS_CONTROL						= 0x00202600,
	///CONSTRUCT_GUI_TREE	

	///Liko 08/15/2005 
	IDST_NORM_TEST_SW_RESULT				=0x00202700,
	IDST_NORM_TEST_LF_RESULT				=0x00202710,
	IDST_NORM_TEST_KS_RESULT				=0x00202720,

	///Bob 10/10/2005
	IDST_KWANOVA_RANKS_RESULT				=0x00202800,
	IDST_NONPARAMETRIC_TTEST_RESULT			=0x00202810,

	/// Iris 10/28/05 Wilcoxon Matched Pairs Test
	IDST_WILCOXON_PAIRS_SCORES_RESULT		=0x00202850,
	
	///Echo 2/13/06
	IDST_NPH_SCORES_RESULT					=0x00202855,
		
	/// Iris 01/09/05 QA70-6367 ADD_EXTREME_VALUES
 	IDST_RM_ANOVA_MULTI_TEST   	 			= 0x00202910,
 	IDST_RM_ANOVA_SPHERICITY_TEST  			= 0x00202920,
 	IDST_RM_ANOVA_WS_ANOVA         			= 0x00202930,
 	IDST_RM_ANOVA_BS_ANOVA         			= 0x00202940,

 	IDST_RM_ANOVA_ONE_DATASET   			= 0x00202950,
 	IDST_RM_ANOVA_DEST_STATS   	 			= 0x00202960,
 	IDST_RM_ANOVA_MEAN_COMP         		= 0x00202970,
 	IDST_RM_ANOVA_ONE_MEAN_COMP     		= 0x00203000,
 	IDST_RM_ANOVA_ONE_MEAN_COMP_END     	= 0x00203100,  //not used, just point to ids range of mean compasion tables
 	///End ADD_EXTREME_VALUES
 	
 	///Echo 9/4/06 XF_REPORT_TREE
 	///XF output report tree of reuslt and plots
 	IDST_XF_RT_RESULT     					= 0x00203150,
 	IDST_XF_RT_PLOT     					= 0x00203160, 	
	///END XF_REPORT_TREE
	
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	IDST_RESULT_GRAPH_TABLE_ROW 			= 0x00203200,
	IDST_RESULT_GRAPH_TABLE_COL 			= 0x00203300,
	///end REPORT_GRAPHS_ARRANGEMENT
	
	/// Iris 01/15/2007 v8.0541 ADD_DATA_LABEL_FOR_EACH_REPORT_GRAPH
	IDST_RESULT_GRAPH_TABLE_LABEL_ROW		= 0x00203400,
	//end ADD_DATA_LABEL_FOR_EACH_REPORT_GRAPH
	
	IDST_PFM_TABLE							= 0x00203500,
	IDST_PFM_ONE_PEAK_RESULT				= 0x00203505,
	///Jasmine 11/10/07 ADD_PFW_FIT_FUNCTIONS_TABLE
	IDST_PFM_FIT_FUNCTIONS					= 0x00203515,	
	IDST_PFM_ONE_FUNCTION					= 0x00203520,	
	///End ADD_PFW_FIT_FUNCTIONS_TABLE

	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	IDST_PFM_SUBTRACTED_DATA_TABLE			= 0x00203530,
	IDST_PFM_ONE_SUBTRACTED_DATA_SET		= 0x00203535,
	IDST_PFM_BASELINE_DATA_TABLE			= 0x00203530,
	IDST_PFM_ONE_BASELINE_DATA_SET			= 0x00203540,	
	///END OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	
	IDST_PFM_BASELINE_ROOT					= 0x00203600,
	//------ Folger 11/27/07 ADD_PFW_MORE_INFORMATION_TABLE
	IDST_PFM_XF_INFO_TABLE					= 0x00203620,
	IDST_PFM_BASELINE_TABLE					= 0x00203625,
	IDST_PFM_BASELINE_TABLE_ROW_X			= 0x00203626,
	IDST_PFM_BASELINE_TABLE_ROW_Y			= 0x00203627,
	IDST_PFM_XF_INFO_TABLE_ROW				= 0x00203630,
	//------
	IDST_PFM_BASELINE_FIT_TABLE				= 0x00203640,
	IDST_PFM_BASELINE_ONE_FIT				= 0x00203645,
	//------ Folger 12/07/07 ADD_BASELINE_INFO_AND_FIT_INFO_TABLE
	IDST_PFM_FIT_INFO_TABLE					= 0x00203650,
	IDST_PFM_BASELINE_INFO_TABLE			= 0x00203655,
	//------
	
	//------ Folger 04/21/08 ADD_BASELINE_MODE_TABLE_IDS
	IDST_PFM_BASELINE_TABLE_ROW_ANCHOR		= 0x00203660,
	IDST_PFM_BASELINE_TABLE_ROW_CONNECT		= 0x00203665,
	IDST_PFM_BASELINE_TABLE_ANCHOR_POINTS	= 0x00203670,
	IDST_PFM_BASELINE_TABLE_RANGE			= 0x00203675,
	//------
	
	//------ Folger 05/04/08 FIX_ANCHOR_POINTS_TABLE_USE_NORMAL_CELL_VALUE_INSTEAD_OF_VECTOR
	IDST_PFM_BASELINE_TABLE_ANCHOR_POINTS_INDEX_BEGIN	=	0x00203680,
	IDST_PFM_BASELINE_TABLE_ANCHOR_POINTS_INDEX_END		=	0x00203780,
	//------
	
	//------ Folger 05/16/08 IMPROVE_BASELINE_MODE_TABLE
	IDST_PFM_BASELINE_TABLE_PARAMETERS				=	0x00203785,
	IDST_PFM_BASELINE_TABLE_PARAMETERS_ITEM_BEGIN	=	0x00203786,
	IDST_PFM_BASELINE_TABLE_PARAMETERS_ITEM_END		=	0x00203795,
	IDST_PFM_BASELINE_TABLE_PARAMETERS_VALUE		=	0x00203796,
	//------
	
	/// Iris 11/18/2008 PA_FIT_SUPPORT_NEW_BASELINE_MODE_XPS
	/*	
	///Jasmine 08/22/08 REPORT_SOURCE_DATA_ROI_IN_NANOSIER 
	IDST_NANOSIZER_ROI_TABLE				= 0x00203800,
	IDST_NANOSIZER_ROI_TABLE_ROWS			= 0x00203810,
	///End REPORT_SOURCE_DATA_ROI_IN_NANOSIER
	*/
	IDST_PFM_BASELINE_TABLE_ROW_XPS_METHOD			=	0x00203800,  
	
	IDST_NANOSIZER_ROI_TABLE						= 0x00205000,
	IDST_NANOSIZER_ROI_TABLE_ROWS					= 0x00205010,
	///end PA_FIT_SUPPORT_NEW_BASELINE_MODE_XPS
	
	///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO
	//IDST_XF_EXECUTION_VALUES				= 0x00203525,
	///---END GET_CREATED_OUTPUT_PAGE_INFO	
	
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
/////////////////////      Section 5, pro only struct and tables     /////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
	IDST_MASK_PRO_ONLY					= 0x10000000,	/// Danice QA70-6232 PRO_ONLY_MASK_FOR_SOME_FEATURE
//---------- CPY ML 8/18/2004 QA70-6825 RLOG_QUERY
// in oc_const.h, need to use internally in VC
//	IDST_MASK_ONE_SET					= 0x20000000,	//---------- CPY ML 8/18/2004 QA70-6825 RLOG_QUERY
//-----------
	IDST_MASK_LAST_ENTRY // not used
}IDE_ID;

///---Sim 04-13-2007 MAKE_MECHANISM_FOR_USER_DATA_ID_IN_XF
/*$
void testUserDataID()
{
	int nID = 1;
	ASSERT(nID < USER_ID_COUNT);
	int n1 = GET_USER_DATAID(nID);
	out_int("ID1: ", n1);
	
	nID = 1000;
	ASSERT(nID < USER_ID_COUNT);
	int n2 = GET_USER_DATAID(nID);
	out_int("ID2: ", n2);
	
	nID = 10001;
	ASSERT(nID < USER_ID_COUNT);
	int n3 = GET_USER_DATAID(nID);
	out_int("ID3: ", n3);
}
**/
#define DATAID_USER_BASE	0x04000
#define USER_ID_COUNT		10000

#define GET_USER_DATAID(_INDEX) (DATAID_USER_BASE + (_INDEX))
///---END MAKE_MECHANISM_FOR_USER_DATA_ID_IN_XF

//---------- CPY ML 8/18/2004 QA70-6825 RLOG_QUERY
// ONE_SET ids are used to fill all the tables
// they are the ids that represent values that appear inside tables as values
// only WORD is allowed
typedef enum tagIDE_ID_ONE_SET
{
	IDST_FIT_PARAMETER_ONE_SET	= 900,
	IDST_REPORT_INPUT_ONE_SET 	= 1000,
	IDST_DESC_STATS_ONE_SET		= 1008,
	IDST_NLSF_STATS_ONE_SET		= 1013,
	IDST_REG_STATS_ONE_SET		= 1018,

	IDST_BIN_X_ONE_SET			= 1020,
	IDST_BIN_COUNT_ONE_SET		= 1022,
	
	IDST_REPORT_MASKED_DATA_ONE_SET	= 1030,
	
	IDST_REPORT_CUSTOM_ONE_SET = 1040, //--- CPY 11/19/04 QA70-7121 CUSTOM_REPORT_TABLES
	// next ID must be at least 200 away, like 1250
	
	/// YuI 04/14/05 MULTIPLE_CURVE_ANALYSIS_BUG
	IDST_REPORT_FITDATA_ONE_SET = 1200,
	/// end MULTIPLE_CURVE_ANALYSIS_BUG
	
	IDST_REPORT_RESIDUAL_DATA_ONE_SET = 1250,  /// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	
	/// Iris 6/14/05 NLSF_SUPPORT_XYZ_DATA
	IDST_REPORT_MATRIX_FITDATA	= 1255,
///Kevin 09/01/05 CHANGE_STATISTICS_NAME
	//IDST_REPORT_MATRIX_LCI	= 1260,
	//IDST_REPORT_MATRIX_UCI	= 1265,
	IDST_REPORT_MATRIX_LCL	= 1260,
	IDST_REPORT_MATRIX_UCL	= 1265,
///End CHANGE_STATISTICS_NAME
	IDST_REPORT_MATRIX_LPI	= 1270,
	IDST_REPORT_MATRIX_UPI	= 1275,
	///END NLSF_SUPPORT_XYZ_DATA
	
	///Iris 4/18/05 SUB_TABLE_ID_FOR_MUL_GRAPHS
	IDST_REPORT_RESIDUAL_HISTOGRAM_ONE_SET = 1500,
	IDST_REPORT_RESIDUAL_FIT_ONE_SET = 1550,
	IDST_REPORT_RESIDUAL_ORDER_ONE_SET = 1600,
	IDST_REPORT_RESIDUAL_SCATTER_ONE_SET = 1650,
	IDST_REPORT_RESIDUAL_LAG_ONE_SET = 1700,	///Jim 2/24/06 v8.0368 ADD_RESIDUAL_LAG_PLOT_TO_RESIDUALS_PLOTS_BRANCH
	IDST_REPORT_PARTIAL_REGRESSION_ONE_SET = 1800,
	/// end SUB_TABLE_ID_FOR_MUL_GRAPHS
	
	/// ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	IDST_REPORT_INPUT_DATA_NLFIT_VAR_BEG	= 1900,
	/// end NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	/// ML 9/5/2006 MASKED_MISSING_NLFIT_TABLES
	IDST_REPORT_MASKED_MISSING_NLFIT_INDEP_BEG	= 2100,
	IDST_REPORT_MASKED_MISSING_NLFIT_DEP_BEG	= 2150,
	IDST_REPORT_MASKED_MISSING_NLFIT_WEIGHT_BEG	= 2200,
	/// end MASKED_MISSING_NLFIT_TABLES
	
	/// ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS
	IDST_REPORT_INPUT_DATA_MULTIX_BEGIN			= 2250,
	IDST_REPORT_INPUT_DATA_MULTIX_EXCEL_BEGIN	= 2350,
	/// end INPUT_DATA_TBL_MR_MULTI_INDEPS

	
	// last entry
	IDST_TEMP_ONE_SET	// this is used to fill table before the actual real value can be found
}IDE_ID_ONE_SET;
//----------- RLOG_QUERY

///---Sim 08-28-2006 ADD_ID_TO_COMM_IMP
typedef enum {
//	IDE_IMP_ORIGINVER				= 0x00000300,
//	IDE_IMP_TYPE					= 0x00000301,
	IDE_IMP_IMPORTMODE				= 0x00000302,
	IDE_IMP_AUTOCOLTYPES			= 0x00000303,
	IDE_IMP_NUMCOLUMNS				= 0x00000304,
	IDE_IMP_PARTIAL					= 0x00000305,
	IDE_IMP_PARTIALC1				= 0x00000306,
	IDE_IMP_PARTIALC2				= 0x00000307,
	IDE_IMP_PARTIALR1				= 0x00000308,
	IDE_IMP_PARTIALR2				= 0x00000309,
	IDE_IMP_RENAMEWKS				= 0x00000310,
//	IDE_IMP_FNAMETOWKSLAB			= 0x00000311,
//	IDE_IMP_COLDESIGN				= 0x00000312,
//	IDE_IMP_COLDESIGNREP			= 0x00000313,
//	IDE_IMP_COLFORMATS				= 0x00000314,
//	IDE_IMP_PAGETYPE				= 0x00000315,
//	IDE_IMP_PAGETEMPLATE			= 0x00000316,
	IDE_IMP_APPLYRANGE				= 0x00000317,
	IDE_IMP_SKIPROWS				= 0x00000318,
	IDE_IMP_READROWS				= 0x00000319,
	IDE_IMP_FLAGS					= 0x00000320,
//	IDE_IMP_FILESPEC				= 0x00000321,
//	IDE_IMP_DESCRIPTION				= 0x00000322,
///---Sim 08-29-2006 ADD_MORE_COMM_ID
	IDE_IMP_POSTIMPSCRIPT			= 0x00000323,
	IDE_IMP_FILE					= 0x00000324,
	IDE_IMP_FUNCTION				= 0x00000325,
	IDE_IMP_CLASS					= 0x00000326,
///---END ADD_MORE_COMM_ID
///------ AW 10/05/06 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
	///---Sim 01-29-2006 RENAME_BOOK_AND_SHEET_IS_COMMON_OPTION
	//IDE_ASCIMP_FILENAME2WKS			= 0x00000327,
	//IDE_ASCIMP_FILENAME2WKSCOMMENT	= 0x00000328,
	//IDE_ASCIMP_FILENAME2COLCOMMENT	= 0x00000329,
	//IDE_ASCIMP_ADDPATH				= 0x00000330,
	//IDE_ASCIMP_REMOVE_QUOTES		= 0x00000331,  /// AW 10/06/06 MORE_ON_XF_THEME_BOOK_AND_SHEET
	IDE_IMP_FILENAME2WKBK			= 0x00000327,
	IDE_IMP_FILENAME2WKBKCOMMENT	= 0x00000328,
	IDE_IMP_FILENAME2COLCOMMENT	= 0x00000329,
	IDE_IMP_ADDPATH				= 0x00000330,
	IDE_IMP_REMOVE_QUOTES		= 0x00000331,  /// AW 10/06/06 MORE_ON_XF_THEME_BOOK_AND_SHEET
	IDE_IMP_ADDPATH4WKBK		= 0x00000332,
	IDE_IMP_WKBKLNONLY			= 0x00000333, ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	///---END RENAME_BOOK_AND_SHEET_IS_COMMON_OPTION

///------ END XF_THEME_BOOK_AND_SHEET

}IDE_COMMON_IMP_ID;
///---END ADD_ID_TO_COMM_IMP

///---Sim 08-28-2006 ADD_ID_TO_DISP_IMP
/*
typedef enum {
	IDE_DISP_IMP_ORIGINVER			= 0x00000350,
	IDE_DISP_IMP_TYPE				= 0x00000351,
	IDE_DISP_IMP_RANGETOGRAPH		= 0x00000352,
	IDE_DISP_IMP_LINKWKS			= 0x00000353,
	IDE_DISP_IMP_COLDESIGN			= 0x00000354,
	IDE_DISP_IMP_COLDESIGNREP		= 0x00000355,
	IDE_DISP_IMP_COLFORMATS			= 0x00000356,
	IDE_DISP_IMP_PLOTTYPE			= 0x00000357,
	IDE_DISP_IMP_PLOTTEMPLATE		= 0x00000358,
	IDE_DISP_IMP_PAGETYPE			= 0x00000359,
	IDE_DISP_IMP_PAGETEMPLATE		= 0x00000360,
	IDE_DISP_IMP_FNAMETOWKSLAB		= 0x00000361,
	IDE_DISP_IMP_FILESPEC			= 0x00000362,
	IDE_DISP_IMP_DESCRIPTION		= 0x00000363
}IDE_DISP_IMP_ID;
*/
///---END ADD_ID_TO_DISP_IMP

///---Sim 08-28-2006 ADD_ID_TO_ASCII_IMP
#define IDE_ASCIMP_AUTOCOLTYPES		IDE_IMP_AUTOCOLTYPES
#define IDE_ASCIMP_IMPORTMODE		IDE_IMP_IMPORTMODE
#define IDE_ASCIMP_NUMCOLUMNS		IDE_IMP_NUMCOLUMNS
#define IDE_ASCIMP_PARTIAL			IDE_IMP_PARTIAL
#define IDE_ASCIMP_PARTIALC1		IDE_IMP_PARTIALC1
#define IDE_ASCIMP_PARTIALC2		IDE_IMP_PARTIALC2
#define IDE_ASCIMP_PARTIALR1		IDE_IMP_PARTIALR1
#define IDE_ASCIMP_PARTIALR2		IDE_IMP_PARTIALR2
#define IDE_ASCIMP_RENAMEWKS		IDE_IMP_RENAMEWKS
#define IDE_ASCIMP_APPLYRANGE		IDE_IMP_APPLYRANGE
#define IDE_ASCIMP_SKIPROWS			IDE_IMP_SKIPROWS
#define IDE_ASCIMP_READROWS			IDE_IMP_READROWS
#define IDE_ASCIMP_FLAGS			IDE_IMP_FLAGS

///---Sim 01-29-2006 RENAME_BOOK_AND_SHEET_IS_COMMON_OPTION
#define	IDE_ASCIMP_FILENAME2WKS			IDE_IMP_FILENAME2WKBK
#define IDE_ASCIMP_WKBKLNONLY			IDE_IMP_WKBKLNONLY ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
#define IDE_ASCIMP_ADDPATH4WKBK			IDE_IMP_ADDPATH4WKBK
#define IDE_ASCIMP_FILENAME2WKSCOMMENT	IDE_IMP_FILENAME2WKBKCOMMENT
#define IDE_ASCIMP_FILENAME2COLCOMMENT	IDE_IMP_FILENAME2COLCOMMENT
#define IDE_ASCIMP_ADDPATH				IDE_IMP_ADDPATH
#define IDE_ASCIMP_REMOVE_QUOTES		IDE_IMP_REMOVE_QUOTES
///---END RENAME_BOOK_AND_SHEET_IS_COMMON_OPTION

typedef enum {
	IDE_ASCIMP_DELIMITED				= 0x00000100,
	IDE_ASCIMP_DELIMCODE				= 0x00000101,
	IDE_ASCIMP_DELIMCHAR				= 0x00000102,
	IDE_ASCIMP_COLWIDTHS				= 0x00000103,
	IDE_ASCIMP_HEADLINES				= 0x00000104,
	IDE_ASCIMP_SUBHEADLINES			= 0x00000105,
	IDE_ASCIMP_AUTOSUBHEAD			= 0x00000106,
	//IDE_ASCIMP_AUTOCOLTYPES			= 0x00000107,
	IDE_ASCIMP_TESTLINES				= 0x00000108,
	//IDE_ASCIMP_IMPORTMODE				= 0x00000109,
	//IDE_ASCIMP_NUMCOLUMNS				= 0x00000110,
	//IDE_ASCIMP_PARTIAL				= 0x00000111,
	//IDE_ASCIMP_PARTIALC1				= 0x00000112,
	//IDE_ASCIMP_PARTIALC2				= 0x00000113,
	//IDE_ASCIMP_PARTIALR1				= 0x00000114,
	//IDE_ASCIMP_PARTIALR2				= 0x00000115,
	//IDE_ASCIMP_RENAMEWKS				= 0x00000116,
	//IDE_ASCIMP_APPLYRANGE				= 0x00000117,
	IDE_ASCIMP_RENAMECOLS				= 0x00000118,
	IDE_ASCIMP_LABEL					= 0x00000119,
	IDE_ASCIMP_MAXLABELS				= 0x00000120,
	IDE_ASCIMP_LEADZERO				= 0x00000121,
	IDE_ASCIMP_NONNUMERIC				= 0x00000122,
	IDE_ASCIMP_MAXTESTLINES			= 0x00000123,
	//IDE_ASCIMP_SKIPROWS				= 0x00000124,
	//IDE_ASCIMP_READROWS				= 0x00000125,
	IDE_ASCIMP_DATEFORMAT				= 0x00000126,
	IDE_ASCIMP_SKIPCHARS				= 0x00000127,
	IDE_ASCIMP_LONGNAMES				= 0x00000128,
	IDE_ASCIMP_UNITS					= 0x00000129,
	IDE_ASCIMP_FIRSTPARAMS				= 0x00000130,
	IDE_ASCIMP_NUMPARAMS				= 0x00000131,
	IDE_ASCIMP_FIRSTSAVE				= 0x00000132,
	IDE_ASCIMP_NUMSAVE					= 0x00000133,
	//IDE_ASCIMP_FLAGS					= 0x00000134,
	IDE_ASCIMP_NUMSEP					= 0x00000135, /// EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	IDE_ASCIMP_DELIMITERS				= 0x00000136, /// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
	IDE_ASCIMP_QUOTECHAR				= 0x00000137, /// EJP 2005-09-28 v8.0312 QA70-7473 ASC_IMP_MULT_DELIM
	IDE_ASCIMP_START_FROM_BOTTOM		= 0x00000138, ///--- CPY AW 10/17/06 NEW_IMPASC_OPTIONS
	IDE_ASCIMP_VERSION					= 0x00000139, /// AW 10/23/06 QA80-9070 NEW_STRUCT_IMPASC_OPTION
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	IDE_ASCIMP_FIRSTUSERPARAMS			= 0x00000140,
	IDE_ASCIMP_NUMUSERPARAMS			= 0x00000141,
	///---END SUPPORT_USER_PARAMETER
	///Cheney 2007-2-6 ADD_OPTION_TO_SUPPORT_SPECIAL_NUM_FORMAT_FOR_ASCIMP
	IDE_ASCIMP_SPECIALFORMAT			= 0x00000142, //for special format, such as BIN, HEX
	IDE_ASCIMP_DELIMITERSARRAY			= 0x00000143, //support Delimiters like "AI", "BIG"
	///end ADD_OPTION_TO_SUPPORT_SPECIAL_NUM_FORMAT_FOR_ASCIMP
	IDE_ASCIMP_USERPARAMSNAMES			= 0x00000144, // Hong 02/24/07 SOPPURT_SET_USER_PARAMETER_NAME
	IDE_ASCIMP_ALLOWALLTEXT				= 0x00000145, /// Hong 12/05/07 v8.0761 IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA
	IDE_ASCIMP_KEEP_DEST_COL_FMT		= 0x00000146, /// Hong 08/31/09 QA80-12899 IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
	IDE_ASCIMP_SAVE_IMP_INFO			= 0x00000147, /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
}IDE_ASCIMP_ID;

/*
/// SY 09/20/2005 ASCII_IMPORT_OPTION_ID_REASSIGN
typedef enum {
	IDE_ASCIMP_DELIMITED				= 0x00000100,
	IDE_ASCIMP_DELIMCODE				= 0x00000101,
	IDE_ASCIMP_DELIMCHAR				= 0x00000102,
	IDE_ASCIMP_COLWIDTHS				= 0x00000103,
	IDE_ASCIMP_HEADLINES				= 0x00000104,
	IDE_ASCIMP_SUBHEADLINES				= 0x00000105,
	IDE_ASCIMP_AUTOSUBHEAD				= 0x00000106,
	IDE_ASCIMP_AUTOCOLTYPES				= 0x00000107,
	IDE_ASCIMP_TESTLINES				= 0x00000108,
	IDE_ASCIMP_IMPORTMODE				= 0x00000109,
	IDE_ASCIMP_NUMCOLUMNS				= 0x00000110,
	IDE_ASCIMP_PARTIAL					= 0x00000111,
	IDE_ASCIMP_PARTIALC1				= 0x00000112,
	IDE_ASCIMP_PARTIALC2				= 0x00000113,
	IDE_ASCIMP_PARTIALR1				= 0x00000114,
	IDE_ASCIMP_PARTIALR2				= 0x00000115,
	IDE_ASCIMP_RENAMEWKS				= 0x00000116,
	IDE_ASCIMP_APPLYRANGE				= 0x00000117,
	IDE_ASCIMP_RENAMECOLS				= 0x00000118,
	IDE_ASCIMP_LABEL					= 0x00000119,
	IDE_ASCIMP_MAXLABELS				= 0x00000120,
	IDE_ASCIMP_LEADZERO					= 0x00000121,
	IDE_ASCIMP_NONNUMERIC				= 0x00000122,
	IDE_ASCIMP_MAXTESTLINES				= 0x00000123,
	IDE_ASCIMP_SKIPROWS					= 0x00000124,
	IDE_ASCIMP_READROWS					= 0x00000125,
	IDE_ASCIMP_DATEFORMAT				= 0x00000126,
	IDE_ASCIMP_SKIPCHARS				= 0x00000127,
	IDE_ASCIMP_LONGNAMES				= 0x00000128,
	IDE_ASCIMP_UNITS					= 0x00000129,
	IDE_ASCIMP_FIRSTPARAMS				= 0x00000130,
	IDE_ASCIMP_NUMPARAMS				= 0x00000131,
	IDE_ASCIMP_FIRSTSAVE				= 0x00000132,
	IDE_ASCIMP_NUMSAVE					= 0x00000133,
	IDE_ASCIMP_FLAGS					= 0x00000134,
	IDE_ASCIMP_NUMSEP					= 0x00000135, /// EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	IDE_ASCIMP_DELIMITERS				= 0x00000136, /// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
	IDE_ASCIMP_QUOTECHAR				= 0x00000137, /// EJP 2005-09-28 v8.0312 QA70-7473 ASC_IMP_MULT_DELIM
}IDE_ASCIMP_ID;
/// end ASCII_IMPORT_OPTION_ID_REASSIGN
*/
///---END ADD_ID_TO_ASCII_IMP

///---Sim 08-28-2006 ADD_ID_TO_BINARY_IMP
/*
//binary structure
#define IDE_BINIMP_AUTOCOLTYPES		IDE_IMP_AUTOCOLTYPES
#define IDE_BINIMP_MODE				IDE_IMP_IMPORTMODE
#define IDE_BINIMP_NUMCOLUMNS		IDE_IMP_NUMCOLUMNS
#define IDE_BINIMP_PARTIAL			IDE_IMP_PARTIAL
#define IDE_BINIMP_PARTIALC1		IDE_IMP_PARTIALC1
#define IDE_BINIMP_PARTIALC2		IDE_IMP_PARTIALC2
#define IDE_BINIMP_PARTIALR1		IDE_IMP_PARTIALR1
#define IDE_BINIMP_PARTIALR2		IDE_IMP_PARTIALR2
#define IDE_BINIMP_RENAMEWKS		IDE_IMP_RENAMEWKS
#define IDE_BINIMP_APPLYRANGE		IDE_IMP_APPLYRANGE
#define IDE_BINIMP_SKIPROWS			IDE_IMP_SKIPROWS
#define IDE_BINIMP_READROWS			IDE_IMP_READROWS
#define IDE_BINIMP_FLAGS			IDE_IMP_FLAGS


typedef enum {
	IDE_BINIMP_HEADERBYTES		= 0x00000200,	
//	IDE_BINIMP_AUTOCOLTYPES		= 0x00000201,	
//	IDE_BINIMP_NUMCOLUMNS		= 0x00000202,	
//	IDE_BINIMP_PARTIAL			= 0x00000203,	
//	IDE_BINIMP_PARTIALC1		= 0x00000204,	
//	IDE_BINIMP_PARTIALC2		= 0x00000205,	
//	IDE_BINIMP_PARTIALR1		= 0x00000206,	
//	IDE_BINIMP_PARTIALR2		= 0x00000207,	
//	IDE_BINIMP_RENAMEWKS		= 0x00000208,	
	IDE_BINIMP_BIGENDIAN		= 0x00000209,	
//	IDE_BINIMP_APPLYRANGE		= 0x00000210,	
//	IDE_BINIMP_MODE				= 0x00000211,	
//	IDE_BINIMP_SKIPROWS			= 0x00000212,	
//	IDE_BINIMP_READROWS			= 0x00000213,
	IDE_BINIMP_PARAMTYPE		= 0x00000214,
	IDE_BINIMP_PARAMSIZE		= 0x00000215,
	IDE_BINIMP_PARAMCOUNT		= 0x00000216,
//	IDE_BINIMP_FLAGS			= 0x00000217,
} IDE_BINIMP_ID;
*/
///---END ADD_ID_TO_BINARY_IMP

/* Hong, rollback change
/// Hong 07/08/08 QA80-11811 v8.0897 IMPROVE_CSV_IMPORT_SPEED_BY_MOVE_OC_TO_VC
#define IDE_CSVIMP_HEADLINES			IDE_ASCIMP_HEADLINES
#define IDE_CSVIMP_SUBHEADLINES			IDE_ASCIMP_SUBHEADLINES	
#define IDE_CSVIMP_RENAMECOLS			IDE_ASCIMP_RENAMECOLS
#define IDE_CSVIMP_LONGNAMES			IDE_ASCIMP_LONGNAMES
#define IDE_CSVIMP_UNITS				IDE_ASCIMP_UNITS
#define IDE_CSVIMP_COMMENT				IDE_ASCIMP_LABEL
#define IDE_CSVIMP_NUMCOMMENT			IDE_ASCIMP_MAXLABELS
#define IDE_CSVIMP_FIRSTPARAMS			IDE_ASCIMP_FIRSTPARAMS
#define IDE_CSVIMP_NUMPARAMS			IDE_ASCIMP_NUMPARAMS
#define IDE_CSVIMP_FIRSTUSERPARAMS		IDE_ASCIMP_FIRSTUSERPARAMS
#define IDE_CSVIMP_NUMUSERPARAMS		IDE_ASCIMP_NUMUSERPARAMS
#define IDE_CSVIMP_PARTIAL				IDE_IMP_PARTIAL
#define IDE_CSVIMP_PARTIALC1			IDE_IMP_PARTIALC1
#define IDE_CSVIMP_PARTIALC2			IDE_IMP_PARTIALC2
#define IDE_CSVIMP_PARTIALR1			IDE_IMP_PARTIALR1
#define IDE_CSVIMP_PARTIALR2			IDE_IMP_PARTIALR2
/// end IMPROVE_CSV_IMPORT_SPEED_BY_MOVE_OC_TO_VC
*/

/// EJP 2006-03-01 v8.0371 MOVE_OC_FILTER_UTILS_TO_VC
typedef enum {
	IDE_FLT_ORIGIN_VER					= 0x000001FF,
	IDE_FLT_TYPE						= 0x00000200,
	IDE_FLT_OC_FILE						= 0x00000201,
	IDE_FLT_OC_FUNC						= 0x00000202,
	IDE_FLT_IMPORT_MODE					= 0x00000203,
	IDE_FLT_RANGE_TO_GRAPH				= 0x00000204,
	IDE_FLT_PARTIAL_IMPORT				= 0x00000205,
	IDE_FLT_PARTIAL_C1					= 0x00000206,
	IDE_FLT_PARTIAL_C2					= 0x00000207,
	IDE_FLT_PARTIAL_R1					= 0x00000208,
	IDE_FLT_PARTIAL_R2					= 0x00000209,
	IDE_FLT_LINK_WKS					= 0x0000020A,
	IDE_FLT_REN_WKS						= 0x0000020B,
	IDE_FLT_FLAGS						= 0x0000020C,
	IDE_FLT_COL_DESIG					= 0x0000020D,
	IDE_FLT_COL_REPEAT_DESIG			= 0x0000020E,
	IDE_FLT_COL_FORMAT					= 0x0000020F,
	IDE_FLT_PLOT_TYPE					= 0x00000210,
	IDE_FLT_PAGE_TYPE					= 0x00000211,
	IDE_FLT_PAGE_TEMPLATE				= 0x00000212,
	IDE_FLT_FNAME_TO_WKS_COMMENTS		= 0x00000213,
	IDE_FLT_HDR_VAR_DEFINED				= 0x00000214,
	IDE_FLT_HDR_VAR_FIRST				= 0x00000215,
	IDE_FLT_HDR_VAR_LAST				= 0x00000216,
	IDE_FLT_HDR_VAR_DELIM				= 0x00000217,
	IDE_FLT_HDR_SAVE_FIRST				= 0x00000218,
	IDE_FLT_HDR_SAVE_COUNT				= 0x00000219,
	IDE_FLT_SKIP_ROWS					= 0x0000021A,
	IDE_FLT_FILE_SPEC					= 0x0000021B,
	IDE_FLT_DESCRIPTION					= 0x0000021C,
	IDE_FLT_PLOT_TEMPL					= 0x0000021D,
	IDE_FLT_XF_SETTING					= 0x0000021E	/// AW 08/18/06 SUPPORT_XF_OPTION_SETTING
} IDE_FLT_ID;
/// end MOVE_OC_FILTER_UTILS_TO_VC

/// ML 11/11/2004 QA70-6845 CELL_VALUE_LINKING
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
////////////////////////      Section 7, Custom tables      //////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//#define	IDE_CUSTOM_TABLE_1			2000
//#define	IDE_CUSTOM_TABLE_2			2001
//#define	IDE_CUSTOM_TABLE_3			2002

#define	IDE_CUSTOM_NODE_1			IDST_SUB1_START //2020
#define	IDE_CUSTOM_NODE_2			IDST_SUB2_START //2021
#define	IDE_CUSTOM_NODE_3			IDST_SUB3_START// 2022
/// end CELL_VALUE_LINKING


//--- CPY 6/28/04	enumerated vector tables or 2D tables

#define IDST_ANOVA_Model		IDST_SUB1_START
#define IDST_ANOVA_Error		IDST_SUB2_START
#define IDST_ANOVA_Total		IDST_SUB3_START
#define IDST_ANOVA_CTotal		IDST_SUB4_START ///Arvin 05/29/07 ADD_CORRECTED_TOTAL_ROW_FOR_ANOVA_TABLE_FOR_FITNL

#define	IDE_INPUT_X				IDST_SUB1_START
/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
//#define	IDE_INPUT_Y				IDST_SUB2_START
#define	IDE_INPUT_MAIN			IDST_SUB2_START
/// end Z_IN_REPORT_TABELS
#define	IDE_INPUT_GROUPBY		IDST_SUB3_START
#define	IDE_INPUT_WEIGHT		IDST_SUB4_START
#define	IDE_INPUT_RANGE			IDST_SUB5_START
#define	IDE_INPUT_X_EXCEL		IDST_SUB6_START
/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
//#define	IDE_INPUT_Y_EXCEL		IDST_SUB7_START
#define	IDE_INPUT_MAIN_EXCEL	IDST_SUB7_START
#define	IDE_INPUT_YINDEP		IDST_SUB8_START
#define	IDE_INPUT_YINDEP_EXCEL	IDST_SUB9_START
/// end Z_IN_REPORT_TABELS
#define IDE_INPUT_X_ERROR		IDST_SUB10_START				///Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
/// ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
#define	IDE_INPUT_NLFIT_DATA		IDST_SUB2_START
#define	IDE_INPUT_NLFIT_DEP_INDEP	IDST_SUB3_START
#define	IDE_INPUT_NLFIT_WEIGHT_TYPE	IDST_SUB4_START
#define	IDE_INPUT_NLFIT_WEIGHT_DATA	IDST_SUB6_START
#define	IDE_INPUT_NLFIT_WEIGHT_A	IDST_SUB7_START
#define	IDE_INPUT_NLFIT_WEIGHT_B	IDST_SUB8_START
#define	IDE_INPUT_NLFIT_WEIGHT_C	IDST_SUB9_START
/// end NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL


#define	IDE_MASKED_ROWS			IDST_SUB1_START
#define	IDE_MASKED_X			IDST_SUB2_START
/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
//#define	IDE_MASKED_Y			IDST_SUB3_START
//#define	IDE_MASKED_WEIGHT		IDST_SUB4_START
#define	IDE_MASKED_MAIN			IDST_SUB3_START
#define	IDE_MASKED_YINDEP		IDST_SUB4_START
#define	IDE_MASKED_WEIGHT		IDST_SUB5_START
/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
#define	IDE_MASKED_ROW			IDST_SUB6_START

/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
#define	IDE_MISSING_ROWS		IDST_SUB1_START
#define	IDE_MISSING_X			IDST_SUB2_START
/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
//#define	IDE_MISSING_Y			IDST_SUB3_START
//#define	IDE_MISSING_WEIGHT		IDST_SUB4_START
#define	IDE_MISSING_MAIN		IDST_SUB3_START
#define	IDE_MISSING_YINDEP		IDST_SUB4_START
#define	IDE_MISSING_WEIGHT		IDST_SUB5_START
/// end Z_IN_REPORT_TABELS
/// end GETTING_MISSING_VALUES_AND_ROWS
#define	IDE_MISSING_ROW			IDST_SUB6_START
#define IDE_MISSING_COLS		IDST_SUB7_START; ///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT



#define IDST_REPORT_OPTIONS_DESC_STATS		IDST_OUTPUT_RESULTS_OPTIONS // Forest 09/09/04, SAVE_SETTING_ON_ALL_LEVELS, output options should use the same ID so that it can copy and paste
#define IDST_REPORT_OPTIONS_LR				IDST_OUTPUT_RESULTS_OPTIONS
#define IDST_REPORT_OPTIONS_PR				IDST_OUTPUT_RESULTS_OPTIONS
#define IDST_REOPRT_OPTIONS_SMOOTHING		IDST_OUTPUT_RESULTS_OPTIONS
#define IDST_REPORT_OPTIONS_TTEST  			IDST_OUTPUT_RESULTS_OPTIONS
#define IDST_REPORT_OPTIONS_FFT_FILTERS		IDST_OUTPUT_RESULTS_OPTIONS	///Danice 11/30/04 QA70-7041
#define IDST_REPORT_OPTIONS_CONVOLUTE		IDST_OUTPUT_RESULTS_OPTIONS	///Danice 12/2/04 QA70-6978
//---

///Forest 03/11/05 QA70-7345 ID_FB_FILTER_GUI
typedef enum tag_ISDT_FB
{
	IDST_FB_SOURCE = 0x00211000,
	IDST_FB_ARGU_TYPE_MUST_BRANCH	 = 0x00211010,
	IDST_FB_ARGU_TYPE_NOT_BRANCH	 = 0x00211020,
	IDST_FB_RETU_VALUE	 = 0x00211030,
	IDST_FB_ARGU_VALUE	 = 0x00211040
}ISDT_FB;
///End ID_FB_FILTER_GUI
/// TD 3-28-05  QA70-7469 CACHE_CONTEXT_BIT_IN_MAP
typedef enum {
	
	IDXF_USGCTXT_LOGICAL_AND	=1,
	
	IDV_NAME 			= 10,
	IDV_DESCRIPTION		= 20,
	IDV_IO				= 30,
	IDV_THEME_ID		= 35, //---- CPY HONG 1/11/08 QA70-10930 THEME_ID_FOR_EACH_VAR
	IDV_TYPE			= 40,
	/// ML 4/29/2005 RETURNING_VALUE_FROM_XFUNCTION
	IDV_RETTYPE			= 41,
	IDV_AUX_OPTIONS		= 42,
	/// end RETURNING_VALUE_FROM_XFUNCTION
	/// ML 7/21/2005 OPTIONAL_MANDATORY_AND_PROHIBITED_ID_CONTEXTS
	IDV_MANDATORY_CTXTS		= 43,
	IDV_PROHIBITED_CTXTS	= 44,
	/// end OPTIONAL_MANDATORY_AND_PROHIBITED_ID_CONTEXTS
	/// ML 8/12/2005 ACCELERATORS_FROM_MENU_TREE
	IDV_ACCEL			= 45,
	/// end ACCELERATORS_FROM_MENU_TREE
	IDV_DATA			= 50,
	/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
	IDV_DATA_X			= 51,
	IDV_DATA_Y			= 52,
	IDV_DATA_ED			= 53, //error dependent
	IDV_DATA_Z			= 54,
	/// end XYDATARANGE_PROPERTY_IMPLEMENTATION

	IDV_DATA_Y2			= 55, //CPY 5/9/06 ANDREW_FOUND_XF2DOC_FAILED_DUE_TO_DUPLICATE_ID

	IDV_DATA_EI			= 56, /// YuI 03/23/09 QA70-12160 XYRANGE_XERROR_SUPPORT
	/// YuI 04/12/05 XVARIABLE_CONTEXT
	IDV_CONTEXT_MODE	= 60,
	IDV_CONTEXT_VAL1	= 61,
	IDV_CONTEXT_VAL2	= 62,
	IDV_CONTEXT_VAL3	= 63,
	/// end XVARIABLE_CONTEXT
	IDV_OPTION_STRING	= 69, // CPY 8/26/05, add optional string to var
	/// ML 5/17/2005 QA70-7686 X_FUNCTION_DRIVEN_MENUS_WITH_TREE
	IDV_COMBO_STRING	= 70,
	IDV_CONTEXT			= 71,
	IDV_OPT_ARG_INDEX	= 72,
	IDV_VERSION			= 73,
	IDV_CATEGORY_BEGIN		= 74,
	IDV_CATEGORY			= IDV_CATEGORY_BEGIN,
	IDV_SEC_CATEGORY_1		= 75,
	IDV_SEC_CATEGORY_2		= 76,
	IDV_CATEGORY_END		= IDV_SEC_CATEGORY_2,
	IDV_SUBCATEGORY_BEGIN	= 77,
	IDV_SUBCATEGORY			= IDV_SUBCATEGORY_BEGIN,
	IDV_SEC_SUBCATEGORY_1	= 78,
	IDV_SEC_SUBCATEGORY_2	= 79,
	IDV_SUBCATEGORY_END		= IDV_SEC_SUBCATEGORY_2,


	IDV_MODULE				= 80,	///DSC 3/15/06 ADD_MODULE_NODE_TO_XF_TREE

	IDV_SUBGROUP		= 82, //---- CPY 6/5/06 MAIN_MENU_NEED_GROUPING

	IDV_PATH			= 85,
	/// end X_FUNCTION_DRIVEN_MENUS_WITH_TREE

	IDV_HELP_TEXT		= 90,  //---- CPY 7/25/05 ADD_HELP_TO_XF

	/// ML 8/18/2005 PROHIBITED_CATEGORIES
	IDV_PROHIB_CATEGORY_BEGIN	= 100,
	IDV_PROHIB_CATEGORY			= IDV_PROHIB_CATEGORY_BEGIN,
	IDV_PROHIB_SEC_CATEGORY_1	= 101,
	IDV_PROHIB_SEC_CATEGORY_2	= 102,
	IDV_PROHIB_CATEGORY_END		= IDV_PROHIB_SEC_CATEGORY_2,
	
	IDV_PROHIB_SUBCATEGORY_BEGIN	= 103,
	IDV_PROHIB_SUBCATEGORY			= IDV_PROHIB_SUBCATEGORY_BEGIN,
	IDV_PROHIB_SEC_SUBCATEGORY_1	= 104,
	IDV_PROHIB_SEC_SUBCATEGORY_2	= 105,
	IDV_PROHIB_SUBCATEGORY_END		= IDV_PROHIB_SEC_SUBCATEGORY_2,
	/// end PROHIBITED_CATEGORIES

	IDXF_SPT_APPLY_UNDO_STATUS = 294, ///---Sim 07-30-2007 SUPPORT_APPLY_AND_UNDO_FOR_DYNA_BOX
	IDXF_SKIP_HIDDEN_IN_DLG=295, //--- CPY 04/20/07 QA80-9657 IMPROVE_EXPORT_GRAPH_BY_SKIP_HIDDEN
	IDXF_CLEAR_ERR_MSG	= 296,	//------ CPY 4/19/07 QA70-9659 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT
	IDXF_SKIP_HELP_DOC	= 297, //----- CPY 4/9/2007 QA70-9585 CHECK_BOX_TO_SKIP_XF2DOC
	IDXF_KEEP_BUTTON_STATUS	= 298, ///---Sim 06-22-2007 OPTION_TO_KEEP_BUTTON_STATUS_ON_EVENT
	IDXF_PREVIEW_BUTTON = 299, ///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM

	//------ Folger 12/03/07 ADD_AUTO_APPLY_CHECKBOX_TO_ENABLE_AUTO_ALLPY_IN_XF_DYNA_DIALOG
	IDXF_AUTO_APPLY_CHKBOX	= 290,
	//------

	IDXF_SUPPORT_FOLDER_LAST_USED_THEME = 291,	///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS

	IDXF_NOT_CLOSE_UPON_ENTER_KEY = 292,	///---Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED

	IDXF_NAME			= 300,
	IDXF_SYNTAX			= 305,//---- CPY 9/10/05 SYNTAX_SHOULD_BE_OUTSIDE_HELP_AND_LANGUAGE_INDEP
	IDXF_DESCRIPTION	= 310,
	IDXF_AUTHOR			= 314,	//---CPY 11/02/08 QA70-12512 XF_MANAGEMENT_DURING_ORIGIN_UPDATE
//	IDXF_INTERNAL		= 315,
	IDXF_ATTACH_TO		= 320,
	IDXF_HEADER			= 323,
	IDXF_CODE_GROUP		= 324, //--- CPY 8/11/05 MOVE_ALL_CODES_TO_SUB_BRANCH
	IDXF_CODE			= 325,
	IDXF_BITMAP			= 326,/// TD 5-19-05 QA70-7739 XFUNCTION_TOOLBAR
	IDXF_EVENT1			= 327,/// TD 6-14-05 QA70-7803 XF_NO_LIMIT_EDITABLE_BLOCKS_SUPPORT
	/// ML 3/24/2005 CONTEXT_MENU_X_FUNCS
	/// ML 5/17/2005 QA70-7686 X_FUNCTION_DRIVEN_MENUS_WITH_TREE
	///// ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION		
	//IDXF_USGCTXT_MAIN_MENUS		= 328,
	///// end X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
	IDXF_USGCTXT_WKS_WORKSHEET	= 328,
	/// end X_FUNCTION_DRIVEN_MENUS_WITH_TREE
	IDXF_USGCTXT				= 329,
	IDXF_USGCTXT_GO				= 330,

	IDXF_USGCTXT_GO_EV_BEGIN	= 331,
	IDXF_USGCTXT_EV_MOVE		= IDXF_USGCTXT_GO_EV_BEGIN,
	IDXF_USGCTXT_EV_MOVING		= 332,
	IDXF_USGCTXT_EV_RESIZE		= 333,
	IDXF_USGCTXT_EV_RESIZING	= 334,
	IDXF_USGCTXT_EV_DELETE		= 335,
	IDXF_USGCTXT_EV_SELECT		= 336,
	IDXF_USGCTXT_EV_UNSELECT	= 337,
	IDXF_USGCTXT_EV_BTNCLICK	= 338,
	/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS
	IDXF_USGCTXT_EV_INITANCHORS	= 339,
	/// end XFUNCTION_ANCHORS
	IDXF_USGCTXT_EV_ROTATE		= 340,
	IDXF_USGCTXT_EV_ROTATING	= 341,
	IDXF_USGCTXT_EV_SKEW		= 342,
	IDXF_USGCTXT_EV_SKEWING		= 343,
	IDXF_USGCTXT_EV_EDIT		= 344,
	IDXF_USGCTXT_EV_EDITING		= 345,
	/// YuI 04/02/08 WORK_ON_PA
	//	IDXF_USGCTXT_GO_EV_END		= IDXF_USGCTXT_EV_EDITING,
	/// RVD 4/1/2008 QA70-11338 v8.0836 DELETE_POLYLINE_SELECTED_POINT
	//IDXF_USGCTXT_EV_DELETE_PART	= 346,
	IDXF_USGCTXT_EV_NEW_SELECTION	= 346,
	IDXF_USGCTXT_EV_DELETE_PART	= 347,
	/// end DELETE_POLYLINE_SELECTED_POINT
	/// RVD 2/17/2009 QA70-13131 ANCHOR_KEY_EVENTS
	//IDXF_USGCTXT_GO_EV_END		= IDXF_USGCTXT_EV_DELETE_PART,
	IDXF_USGCTXT_EV_KEYBOARD	= 348,
	IDXF_USGCTXT_GO_EV_END		= IDXF_USGCTXT_EV_KEYBOARD,
	/// end ANCHOR_KEY_EVENTS
	/// end WORK_ON_PA

	IDXF_USGCTXT_GO_OBJ_TYPE	= 349, //-- CPY 8/14/05 CREATE_LINE_TYPE_OBJ

	IDXF_USGCTXT_WKS_SEL		= 350,

	/// end CACHE_CONTEXT_BIT_IN_MAP
	/// end CONTEXT_MENU_X_FUNCS
	
	//--- DSC
	/// TD 3-28-05  QA70-7469 CACHE_CONTEXT_BIT_IN_MAP
	// Please add all future Context types in the range below an update the range accordingly
	//CPY 9/13/06 change IDXF_USGCTXT_BEGIN to 351 from 353, so IDXF_USGCTXT_THEME_IN_MENU can have a new number (351)
	IDXF_USGCTXT_BEGIN				= 351,//353,
	// 351 still available
	IDXF_USGCTXT_THEME_IN_MENU		= 352,//354, //CPY 8/27/06 QA70-8640 FILE_IMPORT_USING_XF_BUT_NO_NEED_FOR_THEME_IN_MENU
	
	IDXF_USGCTXT_IMPORTWIZ			= 353,//DXF_USGCTXT_BEGIN,	//CPY 8/14/05 XF_FOR_IW_CUSTOM_IMPORT_LIST
	IDXF_USGCTXT_WKS_SEL_CHANGE		= 355,
	IDXF_USGCTXT_WKS_SEL_TRACKING	= 356,
	IDXF_USGCTXT_LABTALK			= 357,
	IDXF_USGCTXT_TO_XF_HEADER		= 358, 
	IDXF_USGCTXT_WINDOW_LAYOUT		= 359, ///CPY 7/16/09 QA80-13947-P6 SLIDESHOW_NEED_LAYOUT_TO_ALSO_ENABLE_MENU
	IDXF_USGCTXT_WINDOW_REPORT		= 360, //---- CPY 12/27/2007 QA70-10869 LAYER_BITS_NEEDED_FOR_ENABLE_XF_MENU
	IDXF_USGCTXT_WINDOW_NONE		= 361, ///------ CPY 07-12-2009 QA80-13872 XFUNCTION_MENUS_FOR_PE_FOLDERS_COMMON_ROOT
	/// ML 5/17/2005 SELECTION_SENSITIVE_XF_CTXT_MENUS
	IDXF_USGCTXT_DATAPLOT_SEL		= 362,
	IDXF_USGCTXT_LAYER_SEL			= 363,
	IDXF_USGCTXT_PAGE_SEL			= 364,
	/// end SELECTION_SENSITIVE_XF_CTXT_MENUS
	/// ML 5/17/2005 QA70-7686 X_FUNCTION_DRIVEN_MENUS_WITH_TREE
	IDXF_USGCTXT_MAIN_MENUS			= 365,
	IDXF_USGCTXT_ADD_AS_TOOL		= 366,
	IDXF_USGCTXT_CLASS_OP			= 367,
	IDXF_USGCTXT_WINDOW_GRAPH		= 368,
	IDXF_USGCTXT_WINDOW_WKS			= 369,
	IDXF_USGCTXT_WINDOW_MATRIX		= 370,
	/// end X_FUNCTION_DRIVEN_MENUS_WITH_TREE

	IDXF_USGCTXT_GETN_DLG			= 371,  //CPY 6/11/05 USE_GETN_DIALOG_OPTIONAL
	/// ML 6/28/2005 ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS
	IDXF_USGCTXT_THEME_APPLICABLE	= 372,		/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
	IDXF_USGCTXT_OUTPUT_TO_TREE		= 373, //CPY 8/24/05

	IDXF_USGCTXT_OPTN_INDEX_OPENS_DLG	= 374, //---- CPY 7/29/08 QA70-11908 REIMPORT_BY_CNTRL_4_SHOULD_NOT_OPEN_DLG

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// !!! Only the context IDs that are needed for fast lookup should be between IDXF_USGCTXT_BEGIN and IDXF_USGCTXT_END !!!  
	IDXF_USGCTXT_END				= 375,
	/// end ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS
	/// YuI 07/28/05 MULTIPLE_XFUNCTION_EVENT_HANDLERS_SUPPORT
	IDXF_EVENT2						= 376,
	/// end MULTIPLE_XFUNCTION_EVENT_HANDLERS_SUPPORT

	/// YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION
	IDXF_EXTENDED_EVENT					= 377,
	/// end XFUNCTION_EVENT2_IMPLEMENTATION

	IDXF_EVENT_GETN_IMAGE			= 378, //--- CPY 9/12/05 GET_N_IMAGE_DIALOG
	
	//---- CPY 9/26/05 QA70-8132 EASIER_EVENT_HANDLERS
	IDXF_EVENT_GETN_STR_ARRAY_BEGIN	= 379, // need +1, +2, +3
	IDXF_EVENT_GETN_STR_ARRAY_END	= 385,
	//----

	/// ---- AW 10/03/06 QA80-9015 v8.0493 ADD_THEME_BRANCH_IN_XF
	IDXF_USGCTXT_THEME				= 386,
	IDXF_THEME_SAVE_IN_BOOK			= 387,
	IDXF_THEME_SAVE_IN_SHEET		= 388,
	/// ----- END ADD_THEME_BRANCH_IN_XF

	//----- CPY 2/3/2007 QA70-9335 XF_RESULTS_LOG_DUMP_MORE_CONTROL
	//IDXF_RESULTS_LOG_OUTPUT			= 390,	//---- CPY 1/27/2007  XF_RESULTS_LOG_OUTPUT_OPTIONS
	//-----

	IDXF_GETN_CUSTOM_BUTTONS		= 391,	//---- CPY 2/1/2007 XF_SUPPORT_CUSTOM_BUTTONS

	//----- CPY 2/3/2007 QA70-9335 XF_RESULTS_LOG_DUMP_MORE_CONTROL
	IDXF_RESULTS_LOG_OUTPUT_ASK		= 393,
	IDXF_RESULTS_LOG_OUTPUT_TYPE	= 394,
	//-----
	/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
	IDXF_USGCTXT_CUSTOM_DIALOG_FILE_NAME_FUNCTION_NAME = 395,
	/// end CUSTOM_XF_DIALOGS
	/// ML 6/28/2005 ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS
	//IDXF_OC_AUTO_DEPENDENT			= 383,	//CPY 6-23-05 QA70-7834 LOAD_DEPENDS_ON_XFCALLS
	/// end ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS

	//// ------------AW 04/03/07 QA80-9548 v8.0597 XF_LOCALIZATION
	//IDV_VAR_HELP_NODEINFO = 404,	///Joseph 03/28/07 ADD_COMBO_NAMES_LIST_FOR_TREE_NODE
	IDV_VAR_HELP_COMBOSTR = 404,
	/// END XF_LOCALIZATION
	IDV_VAR_SUGGESTED_VALUES = 405,
	IDV_VAR_AUTOCOMPLETE_HINT = 406,
	//// ------------AW 04/03/07 QA80-9548 v8.0597 XF_LOCALIZATION
	//IDV_VAR_HELP_COMBOSTR	= 407,
	IDV_VAR_HELP_COMBO_DESC	= 407,
	//// END XF_LOCALIZATION
	IDV_VAR_HELP_DESCRIPTION = 408,		// long anme
	IDV_VAR_HELP_REMARK		= 409,  	// description
	IDV_VAR_LOCAL_HELP_BRANCH		= 410,	//---- CPY 8/23/05 ADD_HELP_TO_XF

	IDV_ERRMSG_COUNT		= 412,
	IDV_ERRMSG_LIST			= 413,

	IDV_HELP_BRANCH			= 420,
	IDV_HELP_SUMMARY		= 421,
	IDV_HELP_BRIEF_INFO		= 422,
	IDV_HELP_SEE_ALSO		= 430,
	IDV_HELP_EXAMPLE		= 431,

	IDV_HELP_REF			= 432,

	IDV_HELP_ALGORITHM		= 434,
	//--------- CPY 4/24/07 QA70-9678 XF_NEED_LT_SAMPLE
	//IDV_HELP_QUICK_EXAMPLE	= 436,
	IDV_HELP_LT_SCRIPT_SAMPLE	= 436,
	//---------

	IDV_MODIFICATION_LOG	= 438, //CPY 9/30/06  ADD_DOC_REVISION_LOG


	IDV_HELP_DESCRIPTION	= 440,

	IDV_HELP_RELATED_XF		= 442, //--- CPY 10/18/05 QA70-8168 SEE_ALSO_FROM_CODE_USING_SEPARATE_NODE

	IDV_HELP_PARAMETERS		= 444, ///DSC 10/27/05 ADD_PARAMETERS_NODE_TO_XFT

	IDV_HELP_SCREEN_SHOT	= 446, //--- CPY 11/2/05 IDV_HELP_SCREEN_SHOT

	IDV_GETN_CUSTOM_BUTTONS	= 448,	//------ Folger 11/08/07 IDV_GETN_CUSTOM_BUTTONS

	/// ML 5/17/2005 QA70-7686 X_FUNCTION_DRIVEN_MENUS_WITH_TREE
	IDXF_USGCTXT_WINDOWS			= 450,
	/// end X_FUNCTION_DRIVEN_MENUS_WITH_TREE
	/// ML 6/28/2005 ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS
	IDXF_OC_AUTO_DEPENDENT			= 451,
	/// TD 12-29-05 Qa70-8431 CHECK_BOX_TO_INDICATE_INCLUDE_FILES_FROM_XF_PATH 
	IDXF_OC_INCLUDE_FROM_FILE_PATH = 452,
	/// end CHECK_BOX_TO_INDICATE_INCLUDE_FILES_FROM_XF_PATH 


	IDXF_OC_CHECK_MENU				= 470,
	IDXF_OC_CHECK_STATUS_DEFAULT	= 472,	// xf.checkStatusDefault for the default value (1)
	/// end ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS
	IDXF_VARS_BEGIN					= 475,  ///Iris 6/14/06 XF_VARS_ADD_DATAID


	///DSC ML 3/31/05 QA70-7500 v8.0215 GET_XF_FROM_ACCELERATOR
	// ID's for Event Organizer
	IDEO_EVENTORG_BEGIN				= 500,
	IDEO_EVENTORG_INFO				= 501,
	IDEO_EVENTORG_INFO1				= 502,
	IDEO_EVENTORG_INFO2				= 503,
	IDEO_EVENTORG_INFO4				= 504,
//	IDEO_EVENTORG_CELLCHANGE		= IDXF_USGCTXT_WKS_SEL_CHANGE
	IDEO_EVENTORG_INFO5				= 506,	
//	IDEO_EVENTORG_CELLTRACK			= IDXF_USGCTXT_WKS_SEL_TRACKING
	IDEO_EVENTORG_WKSINFO			= 508,
	IDEO_EVENTORG_WKSHOTKEY1		= 510,
	IDEO_EVENTORG_WKSHOTKEY2		= 511,
	IDEO_EVENTORG_WKSHOTKEY3		= 512,
	IDEO_EVENTORG_WKSHOTKEY4		= 513,
	IDEO_EVENTORG_WKSHOTKEY5		= 514,
	IDEO_EVENTORG_WKSHOTKEY6		= 515,
	IDEO_EVENTORG_GRINFO			= 516,	
	IDEO_EVENTORG_GRHOTKEY1			= 518,
	IDEO_EVENTORG_GRHOTKEY2			= 519,
	IDEO_EVENTORG_GRHOTKEY3			= 520,
	IDEO_EVENTORG_GRHOTKEY4			= 521,
	IDEO_EVENTORG_GRHOTKEY5			= 522,
	IDEO_EVENTORG_GRHOTKEY6			= 523,

	// add matrix
	IDEO_EVENTORG_MATINFO			= 524,	
	IDEO_EVENTORG_MATHOTKEY1		= 526,
	IDEO_EVENTORG_MATHOTKEY2		= 527,
	IDEO_EVENTORG_MATHOTKEY3		= 528,
	IDEO_EVENTORG_MATHOTKEY4		= 529,
	IDEO_EVENTORG_MATHOTKEY5		= 530,
	IDEO_EVENTORG_MATHOTKEY6		= 531,
	///end GET_XF_FROM_ACCELERATOR

	///DSC 10/18/05 QA70-8167 CONSTRUCT_XF_FDF_TREE_FOR_UPDATE
	IDXF_UPL_FILES				= 550,       
	IDV_UPL_AUTHORID          	= 551,
	IDV_UPL_CREATEON			= 552,
	IDV_OPL_DATE                = 553,     
	IDV_UPL_ORGVERSION        	= 554,
	IDV_UPL_WORKINGVERSIONS   	= 555,
	IDV_UPL_FILENAME         	= 556,
	IDV_UPL_FILESIZE     		= 557,
	IDV_UPL_DOWNLOADEDBYORIGIN	= 558,
	IDV_UPL_CATNAME				= 559,
	///end  CONSTRUCT_XF_FDF_TREE_FOR_UPDATE


	/// TD 2-13-07 QA70-9340 SAVE_ONLY_USER_FUNCTIONS
	IDXF_SAVEINPROJECT			= 560,
	/// end SAVE_ONLY_USER_FUNCTIONS

	IDEO_EVENTORG_WKS				= IDST_TREE_BRANCH_MASK | 1,
	IDEO_EVENTORG_GR				= IDST_TREE_BRANCH_MASK | 2,
	IDEO_EVENTORG_MAT				= IDST_TREE_BRANCH_MASK | 3,


IDXF_LAST_ENTRY
} XFID;
/// end CACHE_CONTEXT_BIT_IN_MAP

///DSC 10/18/05 QA70-8167 CONSTRUCT_XF_FDF_TREE_FOR_UPDATE
#define _FILE_INFO_BRANCH_STR			"Files"

#define FILE_CATEGORY_XF			0x01       
#define FILE_CATEGORY_FDF			0x02   			
#define FILE_CATEGORY_HELP			0x04   
#define FILE_CATEGORY_MODULE		0x08       
#define FILE_CATEGORY_OTHER			0x20   
///end CONSTRUCT_XF_FDF_TREE_FOR_UPDATE


/// SY 2007-03-19 QA70-9471 v8.0585 LOCALIZE_XF_DESCRIPTION
///	//---- CPY 8/26/05 ADD_HELP_TO_XF
///	// various language help are all inside branch ID =  IDV_HELP_BRANCH, but with diff repeat id
///	enum {
///		IDRS_HELP_E = 0x0100, // we need 2 levels of repeat id, so help will go to higher bits in the repeat id WORD
///		IDRS_HELP_J = 0x0200,
///		IDRS_HELP_G = 0x0300,
///		IDRS_HELP_C = 0x0400, // Chinese
///	};
///	//----
/// end LOCALIZE_XF_DESCRIPTION

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///////////////////////    Section 8, repeat branch in GUI    ////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////	
typedef enum tag_GUI_REPEAT_BRANCH_ID
{
	///DSC 9/21/05 QA70-8113 KEEP_REPEAT_BRANCH_ID_FROM_BRANCH_MASK
	// Note: IDST_TREE_BRANCH_MASK = 0x00200000, so if IDRS_TTEST_CONTROL=160=0xa0, then (0xa00000 & IDST_TREE_BRANCH_MASK) is TRUE,
	// We want to avoid this so that when "repeat id" is combined with "data id", the result is not interpreted as a branch.
	// So avoid 0x..2. 
	// IDRS_TTEST_CONTROL		= 160,
	// IDRS_CHISQ_CONTROL		= 162,
	// IDRS_TTEST2_CONTROL		= 164,
	// IDRS_FTEST_CONTROL		= 166,
	IDRS_TTEST_CONTROL			= 0x11,
	IDRS_CHISQ_CONTROL			= 0x12,
	IDRS_TTEST2_CONTROL			= 0x13,
	IDRS_FTEST_CONTROL			= 0x14,
	///end KEEP_REPEAT_BRANCH_ID_FROM_BRANCH_MASK

} GUI_REPEAT_IDS;



/// TD 7-7-05 QA70-7868 ARG_TYPE_QUERY_FOR_XFUNCTION

// LHS:
enum {
	ARGQUERY_INPUT			= 0x1,
	ARGQUERY_OUTPUT			= 0x2,
	ARGQUERY_INPUTOUTPUT	= 0x4,
};

// RHS:
enum {
	ARGQUERY_VECTOR			= 0x1,
	ARGQUERY_DATARANGE		= 0x2,
	ARGQUERY_XYRANGE		= 0x4,
	ARGQUERY_XYZRANGE		= 0x8,
};

/// end ARG_TYPE_QUERY_FOR_XFUNCTION

/// TD 5-19-06 QA70-8579  OC_GENERAL_MECHANISM_TO_SAVE_XFNCTIONS_IN_ORIGIN_FILES
enum
{
	TAGXF_SAVE_IN_FILES = 0x00000001,
};
/// end OC_GENERAL_MECHANISM_TO_SAVE_XFNCTIONS_IN_ORIGIN_FILES


//---- CPY 1/5/07 QA70-7869 MAIN_MENU_CHECK_BECOMES_COMBO
#define STR_MENU_TYPE_ATTRIB "MenuType"
enum {
	XFMENU_UNKNOWN = -1,
	XFMENU_NONE,
	XFMENU_MAIN,
	XFMENU_CONTEXT,
	XFMENU_MAIN_CONTEXT,
	XFMENU_CONTEXT_REGION1, // enumerate from here for region 1,2,3,4,5
};
//----

///---Sim 03-07-2007 QA80-9435 ADD_DATA_ID_FOR_DATA_RANGE_TREE
enum {
	ID_FILEINFO_FILENODE = 100,
	ID_FILEINFO_DATARANGE = 200,
};
//---END QA80-9435 ADD_DATA_ID_FOR_DATA_RANGE_TREE

//------- CPY 4/8/07 MOVE_COMMON_REPORT_TREE_PREP_CODE_TO_GLOBAL_FUNCTION
#define DEFAULT_REOPRT_TREE_ID 10000
//-------

#define		STR_DELAY_DATAID_ASSIGN_ATTRIB	"DataIDAssignDelay"		///------ Folger 02/12/09 QA80-12962 PROPER_ASSIGN_ID_FOR_NEW_ADDED_NODES

///------ Folger 07/01/09 THEME_SAVED_IN_SR5_FAILS_TO_BE_APPLIED_AFTER_NEW_RESULTS_NODE_ADDED_IN_PA
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////        !!!!!!!!!IMPORTANT!!!!!!!!!         ////////////////////////////
/// After added any new node in pa_fit_make_tree(), needs:										//
/// 1. Add a new enum item below with a name PA_DELAY_DATAID_ASSIGN_VER%d, %d is the number 1	//
///	greater than the one before.																//
/// 2. One more line code :																		//
///		trNode.SetAttribute(STR_DELAY_DATAID_ASSIGN_ATTRIB, PA_DELAY_DATAID_ASSIGN_VER%d);		//
//////////////////////////////////////////////////////////////////////////////////////////////////
enum
{
	PA_DELAY_DATAID_ASSIGN_VER1			= 1,
	PA_DELAY_DATAID_ASSIGN_VER2,
	PA_DELAY_DATAID_ASSIGN_VER3,
	PA_DELAY_DATAID_ASSIGN_VER4,		///------ Folger 08/07/09 UNIT_IN_PA_FITTING_PARAMETER_MAKE_OLD_THEME_FAIL_TO_APPLY_IN_81
};
///------ End THEME_SAVED_IN_SR5_FAILS_TO_BE_APPLIED_AFTER_NEW_RESULTS_NODE_ADDED_IN_PA

///------ Folger 05/19/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
#define		STR_DATA_DISPLAY_SETTINGS_COLUMN_INFO_TAGNAME_PREFIX		"Column"

enum
{
	ID_DATAINFOSETTINGS_NUM_COLUMNS					= 1,
	ID_DATAINFOSETTINGS_COLUMN_INFO_FROM,
	ID_DATAINFOSETTINGS_COLUMN_CONTENT,
	ID_DATAINFOSETTINGS_COLUMN_WIDTH,
	ID_DATAINFOSETTINGS_COLUMN_FONT_SIZE,

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	ID_DATAINFOSETTINGS_COLUMN_HEADER,
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO



	ID_DATAINFOSETTINGS_TITLE		= 100,
	ID_DATAINFOSETTINGS_FORMAT,
	ID_DATAINFOSETTINGS_HINT,
	ID_DATAINFOSETTINGS_AVAILABLE,
	ID_DATAINFOSETTINGS_SELECTED,
	ID_DATAINFOSETTINGS_FONT,
	ID_DATAINFOSETTINGS_FONTSIZE,
	ID_DATAINFOSETTINGS_FONTCOLOR,
	ID_DATAINFOSETTINGS_BK_COLOR,
	ID_DATAINFOSETTINGS_FIT_DISPLAY,
	ID_DATAINFOSETTINGS_SHOWGRID,
	///------ Folger 07/07/10 ORG-502-S3 SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR
	ID_DATAINFOSETTINGS_COLHEADER_BK_COLOR,
	///------ End SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR
};
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
#endif //_DATA_IDS_H
